/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.function.Function;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.values.storable.ValueGroup;

public class FusionSlotSelector00
implements SlotSelector {
    @Override
    public void validateSatisfied(InstanceSelector<IndexProvider> instances) {
        SlotSelector.validateSelectorInstances(instances, IndexSlot.LUCENE, IndexSlot.SPATIAL, IndexSlot.TEMPORAL);
    }

    @Override
    public <V> IndexSlot selectSlot(V[] values, Function<V, ValueGroup> groupOf) {
        if (values.length > 1) {
            return IndexSlot.LUCENE;
        }
        ValueGroup singleGroup = groupOf.apply(values[0]);
        switch (singleGroup.category()) {
            case GEOMETRY: {
                return IndexSlot.SPATIAL;
            }
            case TEMPORAL: {
                return IndexSlot.TEMPORAL;
            }
            case UNKNOWN: {
                return null;
            }
        }
        return IndexSlot.LUCENE;
    }
}

