/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.index.schema.CapabilityValidator;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NumberIndexKey;
import org.neo4j.kernel.impl.index.schema.NumberIndexProvider;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class NumberIndexReader<VALUE extends NativeIndexValue>
extends NativeIndexReader<NumberIndexKey, VALUE> {
    NumberIndexReader(GBPTree<NumberIndexKey, VALUE> tree, IndexLayout<NumberIndexKey, VALUE> layout, IndexDescriptor descriptor) {
        super(tree, layout, descriptor);
    }

    @Override
    void validateQuery(IndexOrder indexOrder, IndexQuery[] predicates) {
        if (predicates.length != 1) {
            throw new UnsupportedOperationException();
        }
        CapabilityValidator.validateQuery(NumberIndexProvider.CAPABILITY, indexOrder, predicates);
    }

    @Override
    boolean initializeRangeForQuery(NumberIndexKey treeKeyFrom, NumberIndexKey treeKeyTo, IndexQuery[] predicates) {
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exists: {
                treeKeyFrom.initValueAsLowest(ValueGroup.NUMBER);
                treeKeyTo.initValueAsHighest(ValueGroup.NUMBER);
                break;
            }
            case exact: {
                IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
                treeKeyFrom.from(exactPredicate.value());
                treeKeyTo.from(exactPredicate.value());
                break;
            }
            case range: {
                IndexQuery.RangePredicate rangePredicate = (IndexQuery.RangePredicate)predicate;
                NumberIndexReader.initFromForRange(rangePredicate, treeKeyFrom);
                NumberIndexReader.initToForRange(rangePredicate, treeKeyTo);
                break;
            }
            default: {
                throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
            }
        }
        return false;
    }

    private static void initToForRange(IndexQuery.RangePredicate<?> rangePredicate, NumberIndexKey treeKeyTo) {
        Value toValue = rangePredicate.toValue();
        if (toValue == Values.NO_VALUE) {
            treeKeyTo.initValueAsHighest(ValueGroup.NUMBER);
        } else {
            treeKeyTo.initialize(rangePredicate.toInclusive() ? Long.MAX_VALUE : Long.MIN_VALUE);
            treeKeyTo.from(toValue);
            treeKeyTo.setCompareId(true);
        }
    }

    private static void initFromForRange(IndexQuery.RangePredicate<?> rangePredicate, NumberIndexKey treeKeyFrom) {
        Value fromValue = rangePredicate.fromValue();
        if (fromValue == Values.NO_VALUE) {
            treeKeyFrom.initValueAsLowest(ValueGroup.NUMBER);
        } else {
            treeKeyFrom.initialize(rangePredicate.fromInclusive() ? Long.MIN_VALUE : Long.MAX_VALUE);
            treeKeyFrom.from(fromValue);
            treeKeyFrom.setCompareId(true);
        }
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return true;
    }
}

