/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.LongFunction;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.Numbers;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.DatabaseKernelExtensions;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.impl.api.DatabaseSchemaState;
import org.neo4j.kernel.impl.api.NonTransactionalTokenNameLookup;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.scan.FullLabelStream;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.DelegatingTokenHolder;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.coreapi.schema.BaseNodeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodeKeyConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.NodePropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.UniquenessConstraintDefinition;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.pagecache.PageCacheLifecycle;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.spi.SimpleKernelContext;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyCreator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyDeleter;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyTraverser;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReader;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RelationshipCreator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RelationshipGroupGetter;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.locker.GlobalStoreLocker;
import org.neo4j.kernel.internal.locker.StoreLocker;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.internal.StoreLogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchRelationship;
import org.neo4j.unsafe.batchinsert.internal.BatchRelationshipIterable;
import org.neo4j.unsafe.batchinsert.internal.DirectRecordAccessSet;
import org.neo4j.unsafe.batchinsert.internal.IndexConfigStoreProvider;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;

public class BatchInserterImpl
implements BatchInserter,
IndexConfigStoreProvider {
    private final LifeSupport life;
    private final NeoStores neoStores;
    private final IndexConfigStore indexStore;
    private final DatabaseLayout databaseLayout;
    private final TokenHolders tokenHolders;
    private final IdGeneratorFactory idGeneratorFactory;
    private final IndexProviderMap indexProviderMap;
    private final Log msgLog;
    private final SchemaCache schemaCache;
    private final Config config;
    private final BatchSchemaActions actions;
    private final StoreLocker storeLocker;
    private final PageCache pageCache;
    private final RecordStorageReader storageReader;
    private final StoreLogService logService;
    private final FileSystemAbstraction fileSystem;
    private final Monitors monitors;
    private final JobScheduler jobScheduler;
    private boolean labelsTouched;
    private boolean isShutdown;
    private final LongFunction<Label> labelIdToLabelFunction = new LongFunction<Label>(){

        @Override
        public Label apply(long from) {
            try {
                return Label.label((String)BatchInserterImpl.this.tokenHolders.labelTokens().getTokenById(Numbers.safeCastLongToInt((long)from)).name());
            }
            catch (TokenNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final FlushStrategy flushStrategy;
    private final RelationshipCreator relationshipCreator;
    private final DirectRecordAccessSet recordAccess;
    private final PropertyTraverser propertyTraverser;
    private final PropertyCreator propertyCreator;
    private final PropertyDeleter propertyDeletor;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final RelationshipTypeTokenStore relationshipTypeTokenStore;
    private final PropertyKeyTokenStore propertyKeyTokenStore;
    private final PropertyStore propertyStore;
    private final SchemaStore schemaStore;
    private final NeoStoreIndexStoreView storeIndexStoreView;
    private final LabelTokenStore labelTokenStore;
    private final Locks.Client noopLockClient = new NoOpClient();
    private final long maxNodeId;

    public BatchInserterImpl(File databaseDirectory, FileSystemAbstraction fileSystem, Map<String, String> stringParams, Iterable<KernelExtensionFactory<?>> kernelExtensions) throws IOException {
        BatchInserterImpl.rejectAutoUpgrade(stringParams);
        Map<String, String> params = BatchInserterImpl.getDefaultParams();
        params.putAll(stringParams);
        this.config = Config.defaults(params);
        this.fileSystem = fileSystem;
        this.life = new LifeSupport();
        this.databaseLayout = DatabaseLayout.of((File)databaseDirectory);
        this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        this.life.add((Lifecycle)this.jobScheduler);
        this.storeLocker = this.tryLockStore(fileSystem);
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, this.config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (Log)NullLog.getInstance(), EmptyVersionContextSupplier.EMPTY, this.jobScheduler);
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        this.life.add((Lifecycle)new PageCacheLifecycle(pageCache));
        this.config.augment(GraphDatabaseSettings.logs_directory, databaseDirectory.getCanonicalPath());
        File internalLog = this.config.get(GraphDatabaseSettings.store_internal_log_path);
        this.logService = (StoreLogService)this.life.add((Lifecycle)StoreLogService.withInternalLog((File)internalLog).build(fileSystem));
        this.msgLog = this.logService.getInternalLog(this.getClass());
        boolean dump = this.config.get(GraphDatabaseSettings.dump_configuration);
        this.idGeneratorFactory = new DefaultIdGeneratorFactory(fileSystem);
        LogProvider internalLogProvider = this.logService.getInternalLogProvider();
        RecordFormats recordFormats = RecordFormatSelector.selectForStoreOrConfig(this.config, this.databaseLayout, fileSystem, pageCache, internalLogProvider);
        StoreFactory sf = new StoreFactory(this.databaseLayout, this.config, this.idGeneratorFactory, pageCache, fileSystem, recordFormats, internalLogProvider, EmptyVersionContextSupplier.EMPTY, new OpenOption[0]);
        this.maxNodeId = recordFormats.node().getMaxId();
        if (dump) {
            BatchInserterImpl.dumpConfiguration(params, System.out);
        }
        this.msgLog.info(Thread.currentThread() + " Starting BatchInserter(" + this + ")");
        this.life.start();
        this.neoStores = sf.openAllNeoStores(true);
        this.neoStores.verifyStoreOk();
        this.pageCache = pageCache;
        this.nodeStore = this.neoStores.getNodeStore();
        this.relationshipStore = this.neoStores.getRelationshipStore();
        this.relationshipTypeTokenStore = this.neoStores.getRelationshipTypeTokenStore();
        this.propertyKeyTokenStore = this.neoStores.getPropertyKeyTokenStore();
        this.propertyStore = this.neoStores.getPropertyStore();
        RelationshipGroupStore relationshipGroupStore = this.neoStores.getRelationshipGroupStore();
        this.schemaStore = this.neoStores.getSchemaStore();
        this.labelTokenStore = this.neoStores.getLabelTokenStore();
        this.monitors = new Monitors();
        this.storeIndexStoreView = new NeoStoreIndexStoreView(LockService.NO_LOCK_SERVICE, this.neoStores);
        Dependencies deps = new Dependencies();
        Monitors monitors = new Monitors();
        deps.satisfyDependencies(fileSystem, this.config, this.logService, this.storeIndexStoreView, pageCache, monitors, RecoveryCleanupWorkCollector.immediate());
        DatabaseKernelExtensions extensions = (DatabaseKernelExtensions)this.life.add((Lifecycle)new DatabaseKernelExtensions(new SimpleKernelContext(databaseDirectory, DatabaseInfo.TOOL, deps), kernelExtensions, deps, UnsatisfiedDependencyStrategies.ignore()));
        this.indexProviderMap = (IndexProviderMap)this.life.add((Lifecycle)new DefaultIndexProviderMap((DependencyResolver)extensions));
        DelegatingTokenHolder propertyKeyTokenHolder = new DelegatingTokenHolder(this::createNewPropertyKeyId, "PropertyKey");
        propertyKeyTokenHolder.setInitialTokens(this.propertyKeyTokenStore.getTokens());
        DelegatingTokenHolder relationshipTypeTokenHolder = new DelegatingTokenHolder(this::createNewRelationshipType, "RelationshipType");
        relationshipTypeTokenHolder.setInitialTokens(this.relationshipTypeTokenStore.getTokens());
        DelegatingTokenHolder labelTokenHolder = new DelegatingTokenHolder(this::createNewLabelId, "Label");
        labelTokenHolder.setInitialTokens(this.labelTokenStore.getTokens());
        this.tokenHolders = new TokenHolders(propertyKeyTokenHolder, labelTokenHolder, relationshipTypeTokenHolder);
        this.indexStore = (IndexConfigStore)this.life.add((Lifecycle)new IndexConfigStore(this.databaseLayout, fileSystem));
        this.schemaCache = new SchemaCache(BatchInserterImpl.loadConstraintSemantics(), this.schemaStore, this.indexProviderMap);
        this.actions = new BatchSchemaActions();
        this.recordAccess = new DirectRecordAccessSet(this.neoStores);
        this.relationshipCreator = new RelationshipCreator(new RelationshipGroupGetter(relationshipGroupStore), relationshipGroupStore.getStoreHeaderInt());
        this.propertyTraverser = new PropertyTraverser();
        this.propertyCreator = new PropertyCreator(this.propertyStore, this.propertyTraverser);
        this.propertyDeletor = new PropertyDeleter(this.propertyTraverser);
        this.flushStrategy = new BatchedFlushStrategy(this.recordAccess, this.config.get(GraphDatabaseSettings.batch_inserter_batch_size));
        this.storageReader = new RecordStorageReader(this.neoStores);
    }

    private StoreLocker tryLockStore(FileSystemAbstraction fileSystem) {
        GlobalStoreLocker storeLocker = new GlobalStoreLocker(fileSystem, this.databaseLayout.getStoreLayout());
        try {
            ((StoreLocker)storeLocker).checkLock();
        }
        catch (Exception e) {
            try {
                storeLocker.close();
            }
            catch (IOException ce) {
                e.addSuppressed(ce);
            }
            throw e;
        }
        return storeLocker;
    }

    private static Map<String, String> getDefaultParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GraphDatabaseSettings.pagecache_memory.name(), "32m");
        return params;
    }

    @Override
    public boolean nodeHasProperty(long node, String propertyName) {
        return this.primitiveHasProperty(this.getNodeRecord(node).forChangingData(), propertyName);
    }

    @Override
    public boolean relationshipHasProperty(long relationship, String propertyName) {
        return this.primitiveHasProperty(this.recordAccess.getRelRecords().getOrLoad(relationship, null).forReadingData(), propertyName);
    }

    @Override
    public void setNodeProperty(long node, String propertyName, Object propertyValue) {
        RecordAccess.RecordProxy<NodeRecord, Void> nodeRecord = this.getNodeRecord(node);
        this.setPrimitiveProperty(nodeRecord, propertyName, propertyValue);
        this.flushStrategy.flush();
    }

    @Override
    public void setRelationshipProperty(long relationship, String propertyName, Object propertyValue) {
        RecordAccess.RecordProxy<RelationshipRecord, Void> relationshipRecord = this.getRelationshipRecord(relationship);
        this.setPrimitiveProperty(relationshipRecord, propertyName, propertyValue);
        this.flushStrategy.flush();
    }

    @Override
    public void removeNodeProperty(long node, String propertyName) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        this.propertyDeletor.removePropertyIfExists(this.getNodeRecord(node), propertyKey, this.recordAccess.getPropertyRecords());
        this.flushStrategy.flush();
    }

    @Override
    public void removeRelationshipProperty(long relationship, String propertyName) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        this.propertyDeletor.removePropertyIfExists(this.getRelationshipRecord(relationship), propertyKey, this.recordAccess.getPropertyRecords());
        this.flushStrategy.flush();
    }

    @Override
    public IndexCreator createDeferredSchemaIndex(Label label) {
        return new IndexCreatorImpl(this.actions, label);
    }

    private void setPrimitiveProperty(RecordAccess.RecordProxy<? extends PrimitiveRecord, Void> primitiveRecord, String propertyName, Object propertyValue) {
        int propertyKey = this.getOrCreatePropertyKeyId(propertyName);
        RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords = this.recordAccess.getPropertyRecords();
        this.propertyCreator.primitiveSetProperty(primitiveRecord, propertyKey, ValueUtils.asValue(propertyValue), propertyRecords);
    }

    private void validateIndexCanBeCreated(int labelId, int[] propertyKeyIds) {
        this.verifyIndexOrUniquenessConstraintCanBeCreated(labelId, propertyKeyIds, "Index for given {label;property} already exists");
    }

    private void validateUniquenessConstraintCanBeCreated(int labelId, int[] propertyKeyIds) {
        this.verifyIndexOrUniquenessConstraintCanBeCreated(labelId, propertyKeyIds, "It is not allowed to create node keys, uniqueness constraints or indexes on the same {label;property}");
    }

    private void validateNodeKeyConstraintCanBeCreated(int labelId, int[] propertyKeyIds) {
        this.verifyIndexOrUniquenessConstraintCanBeCreated(labelId, propertyKeyIds, "It is not allowed to create node keys, uniqueness constraints or indexes on the same {label;property}");
    }

    private void verifyIndexOrUniquenessConstraintCanBeCreated(int labelId, int[] propertyKeyIds, String errorMessage) {
        LabelSchemaDescriptor schemaDescriptor = SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds);
        UniquenessConstraintDescriptor constraintDescriptor = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schemaDescriptor);
        NodeKeyConstraintDescriptor nodeKeyDescriptor = ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)schemaDescriptor);
        if (this.schemaCache.hasIndex((SchemaDescriptor)schemaDescriptor) || this.schemaCache.hasConstraintRule(constraintDescriptor) || this.schemaCache.hasConstraintRule(nodeKeyDescriptor)) {
            throw new ConstraintViolationException(errorMessage);
        }
    }

    private void validateNodePropertyExistenceConstraintCanBeCreated(int labelId, int[] propertyKeyIds) {
        NodeExistenceConstraintDescriptor constraintDescriptor = ConstraintDescriptorFactory.existsForLabel(labelId, propertyKeyIds);
        if (this.schemaCache.hasConstraintRule(constraintDescriptor)) {
            throw new ConstraintViolationException("Node property existence constraint for given {label;property} already exists");
        }
    }

    private void validateRelationshipConstraintCanBeCreated(int relTypeId, int propertyKeyId) {
        NodeExistenceConstraintDescriptor constraintDescriptor = ConstraintDescriptorFactory.existsForLabel(relTypeId, propertyKeyId);
        if (this.schemaCache.hasConstraintRule(constraintDescriptor)) {
            throw new ConstraintViolationException("Relationship property existence constraint for given {type;property} already exists");
        }
    }

    private IndexReference createIndex(int labelId, int[] propertyKeyIds) {
        LabelSchemaDescriptor schema = SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds);
        IndexProviderDescriptor providerDescriptor = this.indexProviderMap.getDefaultProvider().getProviderDescriptor();
        StoreIndexDescriptor schemaRule = IndexDescriptorFactory.forSchema((SchemaDescriptor)schema, Optional.empty(), (IndexProviderDescriptor)providerDescriptor).withId(this.schemaStore.nextId());
        for (DynamicRecord record : this.schemaStore.allocateFrom((SchemaRule)schemaRule)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule((SchemaRule)schemaRule);
        this.labelsTouched = true;
        this.flushStrategy.forceFlush();
        return schemaRule;
    }

    private void repopulateAllIndexes(NativeLabelScanStore labelIndex) {
        LogProvider logProvider = this.logService.getInternalLogProvider();
        DynamicIndexStoreView indexStoreView = new DynamicIndexStoreView(this.storeIndexStoreView, labelIndex, LockService.NO_LOCK_SERVICE, this.neoStores, logProvider);
        IndexingService indexingService = (IndexingService)this.life.add((Lifecycle)IndexingServiceFactory.createIndexingService(this.config, this.jobScheduler, this.indexProviderMap, indexStoreView, new NonTransactionalTokenNameLookup(this.tokenHolders), Collections.emptyList(), logProvider, IndexingService.NO_MONITOR, new DatabaseSchemaState(logProvider)));
        try {
            StoreIndexDescriptor[] descriptors = this.getIndexesNeedingPopulation();
            indexingService.createIndexes(true, descriptors);
            for (StoreIndexDescriptor descriptor : descriptors) {
                IndexProxy indexProxy = this.getIndexProxy(indexingService, descriptor);
                try {
                    indexProxy.awaitStoreScanCompleted();
                }
                catch (IndexPopulationFailedKernelException indexPopulationFailedKernelException) {
                    // empty catch block
                }
            }
            indexingService.forceAll(IOLimiter.UNLIMITED);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private IndexProxy getIndexProxy(IndexingService indexingService, StoreIndexDescriptor descriptpr) {
        try {
            return indexingService.getIndexProxy(descriptpr.schema());
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException("Expected index by descriptor " + descriptpr + " to exist, but didn't", e);
        }
    }

    private void rebuildCounts() {
        CountsTracker counts = this.neoStores.getCounts();
        try {
            counts.start();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        CountsComputer.recomputeCounts(this.neoStores, this.pageCache, this.databaseLayout);
    }

    private StoreIndexDescriptor[] getIndexesNeedingPopulation() {
        ArrayList<StoreIndexDescriptor> indexesNeedingPopulation = new ArrayList<StoreIndexDescriptor>();
        for (StoreIndexDescriptor storeIndexDescriptor : this.schemaCache.indexDescriptors()) {
            IndexProvider provider = this.indexProviderMap.lookup(storeIndexDescriptor.providerDescriptor());
            if (provider.getInitialState(storeIndexDescriptor) == InternalIndexState.FAILED) continue;
            indexesNeedingPopulation.add(storeIndexDescriptor);
        }
        return indexesNeedingPopulation.toArray(new StoreIndexDescriptor[0]);
    }

    @Override
    public ConstraintCreator createDeferredConstraint(Label label) {
        return new BaseNodeConstraintCreator(new BatchSchemaActions(), label);
    }

    private void createUniqueIndexAndOwningConstraint(org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor schema, IndexBackedConstraintDescriptor constraintDescriptor) {
        long indexId = this.schemaStore.nextId();
        long constraintRuleId = this.schemaStore.nextId();
        IndexProviderDescriptor providerDescriptor = this.indexProviderMap.getDefaultProvider().getProviderDescriptor();
        StoreIndexDescriptor storeIndexDescriptor = IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)providerDescriptor).withIds(indexId, constraintRuleId);
        ConstraintRule constraintRule = ConstraintRule.constraintRule(constraintRuleId, constraintDescriptor, indexId);
        for (DynamicRecord record : this.schemaStore.allocateFrom(constraintRule)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(constraintRule);
        for (DynamicRecord record : this.schemaStore.allocateFrom((SchemaRule)storeIndexDescriptor)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule((SchemaRule)storeIndexDescriptor);
        this.labelsTouched = true;
        this.flushStrategy.forceFlush();
    }

    private void createUniquenessConstraintRule(org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor descriptor) {
        this.createUniqueIndexAndOwningConstraint(descriptor, ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)descriptor));
    }

    private void createNodeKeyConstraintRule(org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor descriptor) {
        this.createUniqueIndexAndOwningConstraint(descriptor, ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)descriptor));
    }

    private void createNodePropertyExistenceConstraintRule(int labelId, int ... propertyKeyIds) {
        ConstraintRule rule = ConstraintRule.constraintRule(this.schemaStore.nextId(), ConstraintDescriptorFactory.existsForLabel(labelId, propertyKeyIds));
        for (DynamicRecord record : this.schemaStore.allocateFrom(rule)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(rule);
        this.labelsTouched = true;
        this.flushStrategy.forceFlush();
    }

    private void createRelTypePropertyExistenceConstraintRule(int relTypeId, int ... propertyKeyIds) {
        ConstraintRule rule = ConstraintRule.constraintRule(this.schemaStore.nextId(), ConstraintDescriptorFactory.existsForRelType(relTypeId, propertyKeyIds));
        for (DynamicRecord record : this.schemaStore.allocateFrom(rule)) {
            this.schemaStore.updateRecord(record);
        }
        this.schemaCache.addSchemaRule(rule);
        this.flushStrategy.forceFlush();
    }

    private int getOrCreatePropertyKeyId(String name) {
        return this.tokenHolders.propertyKeyTokens().getOrCreateId(name);
    }

    private int getOrCreateRelationshipTypeId(String name) {
        return this.tokenHolders.relationshipTypeTokens().getOrCreateId(name);
    }

    private int getOrCreateLabelId(String name) {
        return this.tokenHolders.labelTokens().getOrCreateId(name);
    }

    private boolean primitiveHasProperty(PrimitiveRecord record, String propertyName) {
        int propertyKeyId = this.tokenHolders.propertyKeyTokens().getIdByName(propertyName);
        return propertyKeyId != -1 && this.propertyTraverser.findPropertyRecordContaining(record, propertyKeyId, this.recordAccess.getPropertyRecords(), false) != (long)Record.NO_NEXT_PROPERTY.intValue();
    }

    private static void rejectAutoUpgrade(Map<String, String> params) {
        if (Boolean.parseBoolean(params.get(GraphDatabaseSettings.allow_upgrade.name()))) {
            throw new IllegalArgumentException("Batch inserter is not allowed to do upgrade of a store.");
        }
    }

    @Override
    public long createNode(Map<String, Object> properties, Label ... labels) {
        return this.internalCreateNode(this.nodeStore.nextId(), properties, labels);
    }

    private long internalCreateNode(long nodeId, Map<String, Object> properties, Label ... labels) {
        NodeRecord nodeRecord = this.recordAccess.getNodeRecords().create(nodeId, null).forChangingData();
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
        nodeRecord.setNextProp(this.propertyCreator.createPropertyChain(nodeRecord, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        if (labels.length > 0) {
            this.setNodeLabels(nodeRecord, labels);
        }
        this.flushStrategy.flush();
        return nodeId;
    }

    private Iterator<PropertyBlock> propertiesIterator(Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return Collections.emptyIterator();
        }
        return new IteratorWrapper<PropertyBlock, Map.Entry<String, Object>>(properties.entrySet().iterator()){

            protected PropertyBlock underlyingObjectToObject(Map.Entry<String, Object> property) {
                return BatchInserterImpl.this.propertyCreator.encodePropertyValue(BatchInserterImpl.this.getOrCreatePropertyKeyId(property.getKey()), ValueUtils.asValue(property.getValue()));
            }
        };
    }

    private void setNodeLabels(NodeRecord nodeRecord, Label ... labels) {
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField(nodeRecord);
        nodeLabels.put(this.getOrCreateLabelIds(labels), this.nodeStore, this.nodeStore.getDynamicLabelStore());
        this.labelsTouched = true;
    }

    private long[] getOrCreateLabelIds(Label[] labels) {
        long[] ids = new long[labels.length];
        int cursor = 0;
        for (int i = 0; i < ids.length; ++i) {
            int labelId = this.getOrCreateLabelId(labels[i].name());
            if (BatchInserterImpl.arrayContains(ids, cursor, labelId)) continue;
            ids[cursor++] = labelId;
        }
        if (cursor < ids.length) {
            ids = Arrays.copyOf(ids, cursor);
        }
        return ids;
    }

    private static boolean arrayContains(long[] ids, int cursor, int labelId) {
        for (int i = 0; i < cursor; ++i) {
            if (ids[i] != (long)labelId) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createNode(long id, Map<String, Object> properties, Label ... labels) {
        IdValidator.assertValidId(IdType.NODE, id, this.maxNodeId);
        if (this.nodeStore.isInUse(id)) {
            throw new IllegalArgumentException("id=" + id + " already in use");
        }
        long highId = this.nodeStore.getHighId();
        if (highId <= id) {
            this.nodeStore.setHighestPossibleIdInUse(id);
        }
        this.internalCreateNode(id, properties, labels);
    }

    @Override
    public void setNodeLabels(long node, Label ... labels) {
        NodeRecord record = this.getNodeRecord(node).forChangingData();
        this.setNodeLabels(record, labels);
        this.flushStrategy.flush();
    }

    @Override
    public Iterable<Label> getNodeLabels(long node) {
        return () -> {
            NodeRecord record = this.getNodeRecord(node).forReadingData();
            long[] labels = NodeLabelsField.parseLabelsField(record).get(this.nodeStore);
            return PrimitiveLongCollections.map(this.labelIdToLabelFunction, (LongIterator)PrimitiveLongCollections.iterator((long[])labels));
        };
    }

    @Override
    public boolean nodeHasLabel(long node, Label label) {
        int labelId = this.tokenHolders.labelTokens().getIdByName(label.name());
        return labelId != -1 && this.nodeHasLabel(node, labelId);
    }

    private boolean nodeHasLabel(long node, int labelId) {
        NodeRecord record = this.getNodeRecord(node).forReadingData();
        for (long label : NodeLabelsField.parseLabelsField(record).get(this.nodeStore)) {
            if (label != (long)labelId) continue;
            return true;
        }
        return false;
    }

    @Override
    public long createRelationship(long node1, long node2, RelationshipType type, Map<String, Object> properties) {
        long id = this.relationshipStore.nextId();
        int typeId = this.getOrCreateRelationshipTypeId(type.name());
        this.relationshipCreator.relationshipCreate(id, typeId, node1, node2, this.recordAccess, this.noopLockClient);
        if (properties != null && !properties.isEmpty()) {
            RelationshipRecord record = this.recordAccess.getRelRecords().getOrLoad(id, null).forChangingData();
            record.setNextProp(this.propertyCreator.createPropertyChain(record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        }
        this.flushStrategy.flush();
        return id;
    }

    @Override
    public void setNodeProperties(long node, Map<String, Object> properties) {
        NodeRecord record = this.getNodeRecord(node).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.propertyDeletor.deletePropertyChain(record, this.recordAccess.getPropertyRecords());
        }
        record.setNextProp(this.propertyCreator.createPropertyChain(record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        this.flushStrategy.flush();
    }

    @Override
    public void setRelationshipProperties(long rel, Map<String, Object> properties) {
        RelationshipRecord record = this.recordAccess.getRelRecords().getOrLoad(rel, null).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.propertyDeletor.deletePropertyChain(record, this.recordAccess.getPropertyRecords());
        }
        record.setNextProp(this.propertyCreator.createPropertyChain(record, this.propertiesIterator(properties), this.recordAccess.getPropertyRecords()));
        this.flushStrategy.flush();
    }

    @Override
    public boolean nodeExists(long nodeId) {
        this.flushStrategy.forceFlush();
        return this.nodeStore.isInUse(nodeId);
    }

    @Override
    public Map<String, Object> getNodeProperties(long nodeId) {
        NodeRecord record = this.getNodeRecord(nodeId).forReadingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return this.getPropertyChain(record.getNextProp());
        }
        return Collections.emptyMap();
    }

    @Override
    public Iterable<Long> getRelationshipIds(long nodeId) {
        this.flushStrategy.forceFlush();
        return new BatchRelationshipIterable<Long>(this.storageReader, nodeId){

            @Override
            protected Long nextFrom(long relId, int type, long startNode, long endNode) {
                return relId;
            }
        };
    }

    @Override
    public Iterable<BatchRelationship> getRelationships(long nodeId) {
        this.flushStrategy.forceFlush();
        return new BatchRelationshipIterable<BatchRelationship>(this.storageReader, nodeId){

            @Override
            protected BatchRelationship nextFrom(long relId, int type, long startNode, long endNode) {
                return BatchInserterImpl.this.batchRelationshipOf(relId, type, startNode, endNode);
            }
        };
    }

    private BatchRelationship batchRelationshipOf(long id, int type, long startNode, long endNode) {
        try {
            return new BatchRelationship(id, startNode, endNode, RelationshipType.withName((String)this.tokenHolders.relationshipTypeTokens().getTokenById(type).name()));
        }
        catch (TokenNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BatchRelationship getRelationshipById(long relId) {
        RelationshipRecord record = this.getRelationshipRecord(relId).forReadingData();
        return this.batchRelationshipOf(relId, record.getType(), record.getFirstNode(), record.getSecondNode());
    }

    @Override
    public Map<String, Object> getRelationshipProperties(long relId) {
        RelationshipRecord record = this.recordAccess.getRelRecords().getOrLoad(relId, null).forChangingData();
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return this.getPropertyChain(record.getNextProp());
        }
        return Collections.emptyMap();
    }

    @Override
    public void shutdown() {
        if (this.isShutdown) {
            throw new IllegalStateException("Batch inserter already has shutdown");
        }
        this.isShutdown = true;
        this.flushStrategy.forceFlush();
        this.rebuildCounts();
        try {
            NativeLabelScanStore labelIndex = this.buildLabelIndex();
            this.repopulateAllIndexes(labelIndex);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.neoStores.close();
            try {
                this.storeLocker.close();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Could not release store lock", e);
            }
            this.msgLog.info(Thread.currentThread() + " Clean shutdown on BatchInserter(" + this + ")");
            this.life.shutdown();
        }
    }

    private NativeLabelScanStore buildLabelIndex() throws IOException {
        NativeLabelScanStore labelIndex = new NativeLabelScanStore(this.pageCache, this.databaseLayout, this.fileSystem, new FullLabelStream(this.storeIndexStoreView), false, this.monitors, RecoveryCleanupWorkCollector.immediate());
        if (this.labelsTouched) {
            labelIndex.drop();
        }
        this.life.add((Lifecycle)labelIndex);
        return labelIndex;
    }

    public String toString() {
        return "EmbeddedBatchInserter[" + this.databaseLayout + "]";
    }

    private Map<String, Object> getPropertyChain(long nextProp) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.propertyTraverser.getPropertyChain(nextProp, this.recordAccess.getPropertyRecords(), propBlock -> {
            try {
                String key = this.tokenHolders.propertyKeyTokens().getTokenById(propBlock.getKeyIndexId()).name();
                Value propertyValue = propBlock.newPropertyValue(this.propertyStore);
                map.put(key, propertyValue.asObject());
            }
            catch (TokenNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        return map;
    }

    private int createNewPropertyKeyId(String stringKey) {
        int keyId = (int)this.propertyKeyTokenStore.nextId();
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(keyId);
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> keyRecords = this.propertyKeyTokenStore.allocateNameRecords(PropertyStore.encodeString(stringKey));
        record.setNameId((int)((DynamicRecord)Iterables.first(keyRecords)).getId());
        record.addNameRecords(keyRecords);
        this.propertyKeyTokenStore.updateRecord(record);
        this.tokenHolders.propertyKeyTokens().addToken(new NamedToken(stringKey, keyId));
        return keyId;
    }

    private int createNewLabelId(String stringKey) {
        int keyId = (int)this.labelTokenStore.nextId();
        LabelTokenRecord record = new LabelTokenRecord(keyId);
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> keyRecords = this.labelTokenStore.allocateNameRecords(PropertyStore.encodeString(stringKey));
        record.setNameId((int)((DynamicRecord)Iterables.first(keyRecords)).getId());
        record.addNameRecords(keyRecords);
        this.labelTokenStore.updateRecord(record);
        this.tokenHolders.labelTokens().addToken(new NamedToken(stringKey, keyId));
        return keyId;
    }

    private int createNewRelationshipType(String name) {
        int id = (int)this.relationshipTypeTokenStore.nextId();
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> nameRecords = this.relationshipTypeTokenStore.allocateNameRecords(PropertyStore.encodeString(name));
        record.setNameId((int)((DynamicRecord)Iterables.first(nameRecords)).getId());
        record.addNameRecords(nameRecords);
        this.relationshipTypeTokenStore.updateRecord(record);
        this.tokenHolders.relationshipTypeTokens().addToken(new NamedToken(name, id));
        return id;
    }

    private RecordAccess.RecordProxy<NodeRecord, Void> getNodeRecord(long id) {
        if (id < 0L || id >= this.nodeStore.getHighId()) {
            throw new NotFoundException("id=" + id);
        }
        return this.recordAccess.getNodeRecords().getOrLoad(id, null);
    }

    private RecordAccess.RecordProxy<RelationshipRecord, Void> getRelationshipRecord(long id) {
        if (id < 0L || id >= this.relationshipStore.getHighId()) {
            throw new NotFoundException("id=" + id);
        }
        return this.recordAccess.getRelRecords().getOrLoad(id, null);
    }

    @Override
    public String getStoreDir() {
        return this.databaseLayout.databaseDirectory().getPath();
    }

    @Override
    public IndexConfigStore getIndexStore() {
        return this.indexStore;
    }

    private static void dumpConfiguration(Map<String, String> config, PrintStream out) {
        for (Map.Entry<String, String> entry : config.entrySet()) {
            if (entry.getValue() == null) continue;
            out.println(entry.getKey() + "=" + entry.getValue());
        }
    }

    @VisibleForTesting
    NeoStores getNeoStores() {
        return this.neoStores;
    }

    void forceFlushChanges() {
        this.flushStrategy.forceFlush();
    }

    private static ConstraintSemantics loadConstraintSemantics() {
        Iterable<ConstraintSemantics> semantics = Service.load(ConstraintSemantics.class);
        List candidates = Iterables.asList(semantics);
        Preconditions.checkState((!candidates.isEmpty() ? 1 : 0) != 0, (String)String.format("At least one implementation of %s should be available.", ConstraintSemantics.class));
        return Collections.max(candidates, Comparator.comparingInt(ConstraintSemantics::getPriority));
    }

    static final class BatchedFlushStrategy
    implements FlushStrategy {
        private final DirectRecordAccessSet directRecordAccess;
        private final int batchSize;
        private int attempts;

        BatchedFlushStrategy(DirectRecordAccessSet directRecordAccess, int batchSize) {
            this.directRecordAccess = directRecordAccess;
            this.batchSize = batchSize;
        }

        @Override
        public void flush() {
            ++this.attempts;
            if (this.attempts >= this.batchSize) {
                this.forceFlush();
            }
        }

        @Override
        public void forceFlush() {
            this.directRecordAccess.commit();
            this.attempts = 0;
        }
    }

    static interface FlushStrategy {
        public void flush();

        public void forceFlush();
    }

    private class BatchSchemaActions
    implements InternalSchemaActions {
        private BatchSchemaActions() {
        }

        private int[] getOrCreatePropertyKeyIds(Iterable<String> properties) {
            return Iterables.stream(properties).mapToInt(x$0 -> BatchInserterImpl.this.getOrCreatePropertyKeyId(x$0)).toArray();
        }

        private int[] getOrCreatePropertyKeyIds(String[] properties) {
            return Arrays.stream(properties).mapToInt(x$0 -> BatchInserterImpl.this.getOrCreatePropertyKeyId(x$0)).toArray();
        }

        @Override
        public IndexDefinition createIndexDefinition(Label label, String ... propertyKeys) {
            int labelId = BatchInserterImpl.this.getOrCreateLabelId(label.name());
            int[] propertyKeyIds = this.getOrCreatePropertyKeyIds(propertyKeys);
            BatchInserterImpl.this.validateIndexCanBeCreated(labelId, propertyKeyIds);
            IndexReference indexReference = BatchInserterImpl.this.createIndex(labelId, propertyKeyIds);
            return new IndexDefinitionImpl((InternalSchemaActions)this, indexReference, new Label[]{label}, propertyKeys, false);
        }

        @Override
        public void dropIndexDefinitions(IndexDefinition indexDefinition) {
            throw this.unsupportedException();
        }

        @Override
        public ConstraintDefinition createPropertyUniquenessConstraint(IndexDefinition indexDefinition) {
            int labelId = BatchInserterImpl.this.getOrCreateLabelId(indexDefinition.getLabel().name());
            int[] propertyKeyIds = this.getOrCreatePropertyKeyIds(indexDefinition.getPropertyKeys());
            LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds);
            BatchInserterImpl.this.validateUniquenessConstraintCanBeCreated(labelId, propertyKeyIds);
            BatchInserterImpl.this.createUniquenessConstraintRule(descriptor);
            return new UniquenessConstraintDefinition((InternalSchemaActions)this, indexDefinition);
        }

        @Override
        public ConstraintDefinition createNodeKeyConstraint(IndexDefinition indexDefinition) {
            int labelId = BatchInserterImpl.this.getOrCreateLabelId(indexDefinition.getLabel().name());
            int[] propertyKeyIds = this.getOrCreatePropertyKeyIds(indexDefinition.getPropertyKeys());
            LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds);
            BatchInserterImpl.this.validateNodeKeyConstraintCanBeCreated(labelId, propertyKeyIds);
            BatchInserterImpl.this.createNodeKeyConstraintRule(descriptor);
            return new NodeKeyConstraintDefinition((InternalSchemaActions)this, indexDefinition);
        }

        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(Label label, String ... propertyKeys) {
            int labelId = BatchInserterImpl.this.getOrCreateLabelId(label.name());
            int[] propertyKeyIds = this.getOrCreatePropertyKeyIds(propertyKeys);
            BatchInserterImpl.this.validateNodePropertyExistenceConstraintCanBeCreated(labelId, propertyKeyIds);
            BatchInserterImpl.this.createNodePropertyExistenceConstraintRule(labelId, propertyKeyIds);
            return new NodePropertyExistenceConstraintDefinition(this, label, propertyKeys);
        }

        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(RelationshipType type, String propertyKey) {
            int relationshipTypeId = BatchInserterImpl.this.getOrCreateRelationshipTypeId(type.name());
            int propertyKeyId = BatchInserterImpl.this.getOrCreatePropertyKeyId(propertyKey);
            BatchInserterImpl.this.validateRelationshipConstraintCanBeCreated(relationshipTypeId, propertyKeyId);
            BatchInserterImpl.this.createRelTypePropertyExistenceConstraintRule(relationshipTypeId, new int[]{propertyKeyId});
            return new RelationshipPropertyExistenceConstraintDefinition(this, type, propertyKey);
        }

        @Override
        public void dropPropertyUniquenessConstraint(Label label, String[] properties) {
            throw this.unsupportedException();
        }

        @Override
        public void dropNodeKeyConstraint(Label label, String[] properties) {
            throw this.unsupportedException();
        }

        @Override
        public void dropNodePropertyExistenceConstraint(Label label, String[] properties) {
            throw this.unsupportedException();
        }

        @Override
        public void dropRelationshipPropertyExistenceConstraint(RelationshipType type, String propertyKey) {
            throw this.unsupportedException();
        }

        @Override
        public String getUserMessage(KernelException e) {
            throw this.unsupportedException();
        }

        @Override
        public void assertInOpenTransaction() {
        }

        private UnsupportedOperationException unsupportedException() {
            return new UnsupportedOperationException("Batch inserter doesn't support this");
        }
    }
}

