/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.kernel.impl.index.schema.TemporalIndexFiles;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPartReader;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPopulatingUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class TemporalIndexPopulator
extends TemporalIndexCache<PartPopulator<?>>
implements IndexPopulator {
    TemporalIndexPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TemporalIndexFiles temporalIndexFiles, PageCache pageCache, FileSystemAbstraction fs, IndexProvider.Monitor monitor) {
        super(new PartFactory(pageCache, fs, temporalIndexFiles, descriptor, samplingConfig, monitor));
    }

    @Override
    public synchronized void create() {
        FusionIndexBase.forAll(NativeIndexPopulator::clear, this);
        if (!this.iterator().hasNext()) {
            this.select(ValueGroup.DATE);
        }
    }

    @Override
    public synchronized void drop() {
        FusionIndexBase.forAll(NativeIndexPopulator::drop, this);
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException {
        HashMap<ValueGroup, List> batchMap = new HashMap<ValueGroup, List>();
        for (IndexEntryUpdate<?> indexEntryUpdate : updates) {
            ValueGroup valueGroup = indexEntryUpdate.values()[0].valueGroup();
            List batch = batchMap.computeIfAbsent(valueGroup, k -> new ArrayList());
            batch.add(indexEntryUpdate);
        }
        for (Map.Entry entry : batchMap.entrySet()) {
            ((PartPopulator)this.select((ValueGroup)entry.getKey())).add((Collection)entry.getValue());
        }
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
    }

    @Override
    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
        return new TemporalIndexPopulatingUpdater(this, accessor);
    }

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully) {
        this.closeInstantiateCloseLock();
        for (NativeIndexPopulator part : this) {
            part.close(populationCompletedSuccessfully);
        }
    }

    @Override
    public synchronized void markAsFailed(String failure) {
        for (NativeIndexPopulator part : this) {
            part.markAsFailed(failure);
        }
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        Value[] values = update.values();
        assert (values.length == 1);
        ((PartPopulator)this.uncheckedSelect(values[0].valueGroup())).includeSample(update);
    }

    @Override
    public IndexSample sampleResult() {
        ArrayList<IndexSample> samples = new ArrayList<IndexSample>();
        for (PartPopulator partPopulator : this) {
            samples.add(partPopulator.sampleResult());
        }
        return FusionIndexSampler.combineSamples(samples);
    }

    static class PartFactory
    implements TemporalIndexCache.Factory<PartPopulator<?>> {
        private final PageCache pageCache;
        private final FileSystemAbstraction fs;
        private final TemporalIndexFiles temporalIndexFiles;
        private final StoreIndexDescriptor descriptor;
        private final IndexSamplingConfig samplingConfig;
        private final IndexProvider.Monitor monitor;

        PartFactory(PageCache pageCache, FileSystemAbstraction fs, TemporalIndexFiles temporalIndexFiles, StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, IndexProvider.Monitor monitor) {
            this.pageCache = pageCache;
            this.fs = fs;
            this.temporalIndexFiles = temporalIndexFiles;
            this.descriptor = descriptor;
            this.samplingConfig = samplingConfig;
            this.monitor = monitor;
        }

        @Override
        public PartPopulator<?> newDate() {
            return this.create(this.temporalIndexFiles.date());
        }

        @Override
        public PartPopulator<?> newLocalDateTime() {
            return this.create(this.temporalIndexFiles.localDateTime());
        }

        @Override
        public PartPopulator<?> newZonedDateTime() {
            return this.create(this.temporalIndexFiles.zonedDateTime());
        }

        @Override
        public PartPopulator<?> newLocalTime() {
            return this.create(this.temporalIndexFiles.localTime());
        }

        @Override
        public PartPopulator<?> newZonedTime() {
            return this.create(this.temporalIndexFiles.zonedTime());
        }

        @Override
        public PartPopulator<?> newDuration() {
            return this.create(this.temporalIndexFiles.duration());
        }

        private <KEY extends NativeIndexSingleValueKey<KEY>> PartPopulator<KEY> create(TemporalIndexFiles.FileLayout<KEY> fileLayout) {
            PartPopulator<KEY> populator = new PartPopulator<KEY>(this.pageCache, this.fs, fileLayout, this.monitor, this.descriptor, this.samplingConfig);
            populator.create();
            return populator;
        }
    }

    static class PartPopulator<KEY extends NativeIndexSingleValueKey<KEY>>
    extends NativeIndexPopulator<KEY, NativeIndexValue> {
        PartPopulator(PageCache pageCache, FileSystemAbstraction fs, TemporalIndexFiles.FileLayout<KEY> fileLayout, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
            super(pageCache, fs, fileLayout.indexFile, fileLayout.layout, monitor, descriptor, samplingConfig, GBPTree.NO_HEADER_WRITER);
        }

        @Override
        IndexReader newReader() {
            return new TemporalIndexPartReader(this.tree, this.layout, this.samplingConfig, this.descriptor);
        }
    }
}

