/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.PhysicalToLogicalLabelChanges;

class NativeLabelScanWriter
implements LabelScanWriter {
    private static final Comparator<NodeLabelUpdate> UPDATE_SORTER = Comparator.comparingLong(NodeLabelUpdate::getNodeId);
    private static final ValueMerger<LabelScanKey, LabelScanValue> ADD_MERGER = (existingKey, newKey, existingValue, newValue) -> existingValue.add((LabelScanValue)newValue);
    private static final ValueMerger<LabelScanKey, LabelScanValue> REMOVE_MERGER = (existingKey, newKey, existingValue, newValue) -> existingValue.remove((LabelScanValue)newValue);
    private Writer<LabelScanKey, LabelScanValue> writer;
    private final LabelScanKey key = new LabelScanKey();
    private final LabelScanValue value = new LabelScanValue();
    private final NodeLabelUpdate[] pendingUpdates;
    private int pendingUpdatesCursor;
    private boolean addition;
    private long lowestLabelId;

    NativeLabelScanWriter(int batchSize) {
        this.pendingUpdates = new NodeLabelUpdate[batchSize];
    }

    NativeLabelScanWriter initialize(Writer<LabelScanKey, LabelScanValue> writer) {
        this.writer = writer;
        this.pendingUpdatesCursor = 0;
        this.addition = false;
        this.lowestLabelId = Long.MAX_VALUE;
        return this;
    }

    @Override
    public void write(NodeLabelUpdate update) throws IOException {
        if (this.pendingUpdatesCursor == this.pendingUpdates.length) {
            this.flushPendingChanges();
        }
        this.pendingUpdates[this.pendingUpdatesCursor++] = update;
        PhysicalToLogicalLabelChanges.convertToAdditionsAndRemovals(update);
        this.checkNextLabelId(update.getLabelsBefore());
        this.checkNextLabelId(update.getLabelsAfter());
    }

    private void checkNextLabelId(long[] labels) {
        if (labels.length > 0 && labels[0] != -1L) {
            this.lowestLabelId = Long.min(this.lowestLabelId, labels[0]);
        }
    }

    private void flushPendingChanges() throws IOException {
        Arrays.sort(this.pendingUpdates, 0, this.pendingUpdatesCursor, UPDATE_SORTER);
        long currentLabelId = this.lowestLabelId;
        this.value.clear();
        this.key.clear();
        while (currentLabelId != Long.MAX_VALUE) {
            long nextLabelId = Long.MAX_VALUE;
            for (int i = 0; i < this.pendingUpdatesCursor; ++i) {
                NodeLabelUpdate update = this.pendingUpdates[i];
                long nodeId = update.getNodeId();
                nextLabelId = this.extractChange(update.getLabelsAfter(), currentLabelId, nodeId, nextLabelId, true);
                nextLabelId = this.extractChange(update.getLabelsBefore(), currentLabelId, nodeId, nextLabelId, false);
            }
            currentLabelId = nextLabelId;
        }
        this.flushPendingRange();
        this.pendingUpdatesCursor = 0;
    }

    private long extractChange(long[] labels, long currentLabelId, long nodeId, long nextLabelId, boolean addition) throws IOException {
        long labelId;
        long foundNextLabelId = nextLabelId;
        for (int li = 0; li < labels.length && (labelId = labels[li]) != -1L; ++li) {
            if (labelId == currentLabelId) {
                this.change(currentLabelId, nodeId, addition);
                if (li + 1 >= labels.length || labels[li + 1] == -1L) break;
                long nextLabelCandidate = labels[li + 1];
                if (nextLabelCandidate < currentLabelId) {
                    throw new IllegalArgumentException("The node label update contained unsorted label ids " + Arrays.toString(labels));
                }
                if (nextLabelCandidate <= currentLabelId) break;
                foundNextLabelId = Long.min(foundNextLabelId, nextLabelCandidate);
                break;
            }
            if (labelId <= currentLabelId) continue;
            foundNextLabelId = Long.min(foundNextLabelId, labelId);
        }
        return foundNextLabelId;
    }

    private void change(long currentLabelId, long nodeId, boolean add) throws IOException {
        int labelId = Math.toIntExact(currentLabelId);
        long idRange = NativeLabelScanWriter.rangeOf(nodeId);
        if (labelId != this.key.labelId || idRange != this.key.idRange || this.addition != add) {
            this.flushPendingRange();
            this.key.labelId = labelId;
            this.key.idRange = idRange;
            this.addition = add;
        }
        this.value.set(Math.toIntExact(nodeId % 64L));
    }

    private void flushPendingRange() throws IOException {
        if (this.value.bits != 0L) {
            this.writer.merge((Object)this.key, (Object)this.value, this.addition ? ADD_MERGER : REMOVE_MERGER);
            this.value.clear();
        }
    }

    static long rangeOf(long nodeId) {
        return nodeId / 64L;
    }

    @Override
    public void close() throws IOException {
        try {
            this.flushPendingChanges();
        }
        finally {
            this.writer.close();
        }
    }
}

