/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public enum IndexEntityType {
    Node(0){

        @Override
        public Class<? extends PropertyContainer> entityClass() {
            return Node.class;
        }
    }
    ,
    Relationship(1){

        @Override
        public Class<? extends PropertyContainer> entityClass() {
            return Relationship.class;
        }
    };

    private final byte id;

    private IndexEntityType(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public abstract Class<? extends PropertyContainer> entityClass();

    public static IndexEntityType byId(byte id) {
        for (IndexEntityType type : IndexEntityType.values()) {
            if (type.id() != id) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown id " + id);
    }

    public String nameToLowerCase() {
        return this.name().toLowerCase();
    }
}

