/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.UnavailableException;

public class CoreAPIAvailabilityGuard {
    private final DatabaseAvailabilityGuard guard;
    private final long timeout;

    public CoreAPIAvailabilityGuard(DatabaseAvailabilityGuard guard, long timeout) {
        this.guard = guard;
        this.timeout = timeout;
    }

    public boolean isAvailable(long timeoutMillis) {
        return this.guard.isAvailable(timeoutMillis);
    }

    public void assertDatabaseAvailable() {
        try {
            this.guard.await(this.timeout);
        }
        catch (UnavailableException e) {
            if (this.guard.isShutdown()) {
                throw new DatabaseShutdownException();
            }
            throw new TransactionFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

