/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.storageengine.api.StorageCommand;

public class PhysicalTransactionRepresentation
implements TransactionRepresentation {
    private final Collection<StorageCommand> commands;
    private byte[] additionalHeader;
    private int masterId;
    private int authorId;
    private long timeStarted;
    private long latestCommittedTxWhenStarted;
    private long timeCommitted;
    private int lockSessionIdentifier;

    public PhysicalTransactionRepresentation(Collection<StorageCommand> commands) {
        this.commands = commands;
    }

    public void setHeader(byte[] additionalHeader, int masterId, int authorId, long timeStarted, long latestCommittedTxWhenStarted, long timeCommitted, int lockSession) {
        this.additionalHeader = additionalHeader;
        this.masterId = masterId;
        this.authorId = authorId;
        this.timeStarted = timeStarted;
        this.latestCommittedTxWhenStarted = latestCommittedTxWhenStarted;
        this.timeCommitted = timeCommitted;
        this.lockSessionIdentifier = lockSession;
    }

    public boolean accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        for (StorageCommand command : this.commands) {
            if (!visitor.visit((Object)command)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] additionalHeader() {
        return this.additionalHeader;
    }

    @Override
    public int getMasterId() {
        return this.masterId;
    }

    @Override
    public int getAuthorId() {
        return this.authorId;
    }

    @Override
    public long getTimeStarted() {
        return this.timeStarted;
    }

    @Override
    public long getLatestCommittedTxWhenStarted() {
        return this.latestCommittedTxWhenStarted;
    }

    @Override
    public long getTimeCommitted() {
        return this.timeCommitted;
    }

    @Override
    public int getLockSessionId() {
        return this.lockSessionIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalTransactionRepresentation that = (PhysicalTransactionRepresentation)o;
        return this.authorId == that.authorId && this.latestCommittedTxWhenStarted == that.latestCommittedTxWhenStarted && this.masterId == that.masterId && this.timeStarted == that.timeStarted && Arrays.equals(this.additionalHeader, that.additionalHeader) && this.commands.equals(that.commands);
    }

    public int hashCode() {
        int result = this.commands.hashCode();
        result = 31 * result + (this.additionalHeader != null ? Arrays.hashCode(this.additionalHeader) : 0);
        result = 31 * result + this.masterId;
        result = 31 * result + this.authorId;
        result = 31 * result + (int)(this.timeStarted ^ this.timeStarted >>> 32);
        result = 31 * result + (int)(this.latestCommittedTxWhenStarted ^ this.latestCommittedTxWhenStarted >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        builder.append("masterId:").append(this.masterId).append(',');
        builder.append("authorId:").append(this.authorId).append(',');
        builder.append("timeStarted:").append(this.timeStarted).append(',');
        builder.append("latestCommittedTxWhenStarted:").append(this.latestCommittedTxWhenStarted).append(',');
        builder.append("timeCommitted:").append(this.timeCommitted).append(',');
        builder.append("lockSession:").append(this.lockSessionIdentifier).append(',');
        builder.append("additionalHeader:").append(Arrays.toString(this.additionalHeader));
        for (StorageCommand command : this.commands) {
            builder.append('\n').append(command);
        }
        return builder.toString();
    }
}

