/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.schema.BridgingIndexProgressor;
import org.neo4j.kernel.impl.index.schema.CapabilityValidator;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.SpatialHitIndexProgressor;
import org.neo4j.kernel.impl.index.schema.SpatialIndexKey;
import org.neo4j.kernel.impl.index.schema.SpatialIndexProvider;
import org.neo4j.kernel.impl.index.schema.SpatialLayout;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class SpatialIndexPartReader<VALUE extends NativeIndexValue>
extends NativeIndexReader<SpatialIndexKey, VALUE> {
    private final SpatialLayout spatial;
    private final SpaceFillingCurveConfiguration configuration;

    SpatialIndexPartReader(GBPTree<SpatialIndexKey, VALUE> tree, Layout<SpatialIndexKey, VALUE> layout, IndexSamplingConfig samplingConfig, IndexDescriptor descriptor, SpaceFillingCurveConfiguration configuration) {
        super(tree, layout, samplingConfig, descriptor);
        this.spatial = (SpatialLayout)layout;
        this.configuration = configuration;
    }

    @Override
    void validateQuery(IndexOrder indexOrder, IndexQuery[] predicates) {
        if (predicates.length != 1) {
            throw new UnsupportedOperationException("Spatial index doesn't handle composite queries");
        }
        CapabilityValidator.validateQuery(SpatialIndexProvider.CAPABILITY, indexOrder, predicates);
    }

    @Override
    boolean initializeRangeForQuery(SpatialIndexKey treeKeyFrom, SpatialIndexKey treeKeyTo, IndexQuery[] predicates) {
        throw new UnsupportedOperationException("Cannot initialize 1D range in multidimensional spatial index reader");
    }

    @Override
    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) {
        NodeValueIterator nodeValueIterator = new NodeValueIterator();
        this.query(nodeValueIterator, IndexOrder.NONE, nodeValueIterator.needsValues(), predicates);
        return nodeValueIterator;
    }

    @Override
    public void query(IndexProgressor.NodeValueClient cursor, IndexOrder indexOrder, boolean needsValues, IndexQuery ... predicates) {
        if (needsValues) {
            throw new IllegalStateException("Spatial index does not support providing values");
        }
        this.validateQuery(indexOrder, predicates);
        IndexQuery predicate = predicates[0];
        SpatialIndexKey treeKeyFrom = (SpatialIndexKey)((Object)this.layout.newKey());
        SpatialIndexKey treeKeyTo = (SpatialIndexKey)((Object)this.layout.newKey());
        this.initializeKeys(treeKeyFrom, treeKeyTo);
        switch (predicate.type()) {
            case exists: {
                this.startSeekForExists(treeKeyFrom, treeKeyTo, cursor, predicate);
                break;
            }
            case exact: {
                this.startSeekForExact(treeKeyFrom, treeKeyTo, cursor, ((IndexQuery.ExactPredicate)predicate).value(), predicate);
                break;
            }
            case range: {
                IndexQuery.GeometryRangePredicate rangePredicate = (IndexQuery.GeometryRangePredicate)predicate;
                if (!rangePredicate.crs().equals((Object)this.spatial.crs)) {
                    throw new IllegalArgumentException("IndexQuery on spatial index with mismatching CoordinateReferenceSystem: " + rangePredicate.crs() + " != " + this.spatial.crs);
                }
                this.startSeekForRange(cursor, rangePredicate, predicates);
                break;
            }
            default: {
                throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
            }
        }
    }

    private void startSeekForExists(SpatialIndexKey treeKeyFrom, SpatialIndexKey treeKeyTo, IndexProgressor.NodeValueClient client, IndexQuery ... predicates) {
        treeKeyFrom.initValueAsLowest(ValueGroup.GEOMETRY);
        treeKeyTo.initValueAsHighest(ValueGroup.GEOMETRY);
        this.startSeekForInitializedRange(client, treeKeyFrom, treeKeyTo, predicates, false, false);
    }

    private void startSeekForExact(SpatialIndexKey treeKeyFrom, SpatialIndexKey treeKeyTo, IndexProgressor.NodeValueClient client, Value value, IndexQuery ... predicates) {
        treeKeyFrom.from(value);
        treeKeyTo.from(value);
        this.startSeekForInitializedRange(client, treeKeyFrom, treeKeyTo, predicates, false, false);
    }

    private void startSeekForRange(IndexProgressor.NodeValueClient client, IndexQuery.GeometryRangePredicate rangePredicate, IndexQuery[] query) {
        try {
            BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(client, this.descriptor.schema().getPropertyIds());
            client.initialize(this.descriptor, (IndexProgressor)multiProgressor, query, false);
            SpaceFillingCurve curve = this.spatial.getSpaceFillingCurve();
            double[] from = rangePredicate.from() == null ? null : rangePredicate.from().coordinate();
            double[] to = rangePredicate.to() == null ? null : rangePredicate.to().coordinate();
            List ranges = curve.getTilesIntersectingEnvelope(from, to, this.configuration);
            for (SpaceFillingCurve.LongRange range : ranges) {
                SpatialIndexKey treeKeyFrom = (SpatialIndexKey)((Object)this.layout.newKey());
                SpatialIndexKey treeKeyTo = (SpatialIndexKey)((Object)this.layout.newKey());
                this.initializeKeys(treeKeyFrom, treeKeyTo);
                treeKeyFrom.fromDerivedValue(Long.MIN_VALUE, range.min);
                treeKeyTo.fromDerivedValue(Long.MAX_VALUE, range.max + 1L);
                RawCursor seeker = this.makeIndexSeeker(treeKeyFrom, treeKeyTo);
                SpatialHitIndexProgressor hitProgressor = new SpatialHitIndexProgressor(seeker, client, this.openSeekers);
                multiProgressor.initialize(this.descriptor, hitProgressor, query, false);
            }
        }
        catch (IllegalArgumentException e) {
            client.initialize(this.descriptor, IndexProgressor.EMPTY, query, false);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    void startSeekForInitializedRange(IndexProgressor.NodeValueClient client, SpatialIndexKey treeKeyFrom, SpatialIndexKey treeKeyTo, IndexQuery[] query, boolean needFilter, boolean needsValues) {
        assert (!needsValues);
        if (this.layout.compare((Object)treeKeyFrom, (Object)treeKeyTo) > 0) {
            client.initialize(this.descriptor, IndexProgressor.EMPTY, query, false);
            return;
        }
        try {
            RawCursor seeker = this.makeIndexSeeker(treeKeyFrom, treeKeyTo);
            SpatialHitIndexProgressor hitProgressor = new SpatialHitIndexProgressor(seeker, client, this.openSeekers);
            client.initialize(this.descriptor, hitProgressor, query, false);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return false;
    }

    private void initializeKeys(SpatialIndexKey treeKeyFrom, SpatialIndexKey treeKeyTo) {
        treeKeyFrom.initialize(Long.MIN_VALUE);
        treeKeyTo.initialize(Long.MAX_VALUE);
    }
}

