/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.concurrent.atomic.LongAdder;
import org.neo4j.unsafe.impl.batchimport.staging.Downstream;
import org.neo4j.unsafe.impl.batchimport.staging.TicketedBatch;
import org.neo4j.util.concurrent.Work;

class SendDownstream
implements Work<Downstream, SendDownstream> {
    private final LongAdder downstreamIdleTime;
    private TicketedBatch head;
    private TicketedBatch tail;

    SendDownstream(long ticket, Object batch, LongAdder downstreamIdleTime) {
        TicketedBatch b;
        this.downstreamIdleTime = downstreamIdleTime;
        this.head = b = new TicketedBatch(ticket, batch);
        this.tail = b;
    }

    public SendDownstream combine(SendDownstream work) {
        this.tail.next = work.head;
        this.tail = work.tail;
        return this;
    }

    public void apply(Downstream downstream) {
        TicketedBatch next = this.head;
        do {
            downstream.queue(next);
        } while ((next = next.next) != null);
        this.downstreamIdleTime.add(downstream.send());
    }
}

