/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.util.Arrays;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;
import org.neo4j.values.storable.CSVHeaderInformation;

public class Header
implements Cloneable {
    private final Entry[] entries;

    public Header(Entry ... entries) {
        this.entries = entries;
    }

    public Entry[] entries() {
        return this.entries;
    }

    public Entry entry(Type type) {
        Entry result = null;
        for (Entry entry : this.entries) {
            if (entry.type() != type) continue;
            if (result != null) {
                throw new IllegalStateException("Multiple header entries of type " + (Object)((Object)type));
            }
            result = entry;
        }
        return result;
    }

    public String toString() {
        return Arrays.toString(this.entries);
    }

    public Header clone() {
        Entry[] entries = new Entry[this.entries.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = this.entries[i].clone();
        }
        return new Header(entries);
    }

    public static class Entry
    implements Cloneable {
        private final String name;
        private final Type type;
        private final Group group;
        private final Extractor<?> extractor;
        private final CSVHeaderInformation optionalParameter;

        public Entry(String name, Type type, Group group, Extractor<?> extractor) {
            this.name = name;
            this.type = type;
            this.group = group;
            this.extractor = extractor;
            this.optionalParameter = null;
        }

        public Entry(String name, Type type, Group group, Extractor<?> extractor, CSVHeaderInformation optionalParameter) {
            this.name = name;
            this.type = type;
            this.group = group;
            this.extractor = extractor;
            this.optionalParameter = optionalParameter;
        }

        public String toString() {
            if (this.optionalParameter == null) {
                return (this.name != null ? this.name : "") + ":" + (this.type == Type.PROPERTY ? this.extractor.name().toLowerCase() : this.type.name()) + (this.group() != Group.GLOBAL ? "(" + this.group().name() + ")" : "");
            }
            return (this.name != null ? this.name : "") + ":" + (this.type == Type.PROPERTY ? this.extractor.name().toLowerCase() + "[" + this.optionalParameter + "]" : this.type.name()) + (this.group() != Group.GLOBAL ? "(" + this.group().name() + ")" : "");
        }

        public Extractor<?> extractor() {
            return this.extractor;
        }

        public Type type() {
            return this.type;
        }

        public Group group() {
            return this.group != null ? this.group : Group.GLOBAL;
        }

        public String name() {
            return this.name;
        }

        public CSVHeaderInformation optionalParameter() {
            return this.optionalParameter;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            if (this.name != null) {
                result = 31 * result + this.name.hashCode();
            }
            result = 31 * result + this.type.hashCode();
            if (this.group != null) {
                result = 31 * result + this.group.hashCode();
            }
            result = 31 * result + this.extractor.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return this.nullSafeEquals(this.name, other.name) && this.type == other.type && this.nullSafeEquals(this.group, other.group) && this.extractorEquals(this.extractor, other.extractor) && this.nullSafeEquals(this.optionalParameter, other.optionalParameter);
        }

        public Entry clone() {
            return new Entry(this.name, this.type, this.group, this.extractor != null ? this.extractor.clone() : null, this.optionalParameter);
        }

        private boolean nullSafeEquals(Object o1, Object o2) {
            return o1 == null || o2 == null ? o1 == o2 : o1.equals(o2);
        }

        private boolean extractorEquals(Extractor<?> first, Extractor<?> other) {
            if (first == null || other == null) {
                return first == other;
            }
            return first.getClass().equals(other.getClass());
        }
    }

    public static interface Factory {
        public Header create(CharSeeker var1, Configuration var2, IdType var3, Groups var4);

        public boolean isDefined();
    }
}

