/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.schema;

import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaComputer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;

public interface SchemaRule
extends SchemaDescriptorSupplier {
    public static String nameOrDefault(String name, String defaultName) {
        if (name == null) {
            return defaultName;
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Schema rule name cannot be the empty string");
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (ch != '\u0000') continue;
            throw new IllegalArgumentException("Illegal schema rule name: '" + name + "'");
        }
        return name;
    }

    public static String checkName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Schema rule name cannot be the empty string");
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (ch != '\u0000') continue;
            throw new IllegalArgumentException("Illegal schema rule name: '" + name + "'");
        }
        return name;
    }

    public long getId();

    public String getName();

    @Deprecated
    public static enum Kind {
        INDEX_RULE("Index"),
        CONSTRAINT_INDEX_RULE("Constraint index"),
        UNIQUENESS_CONSTRAINT("Uniqueness constraint"),
        NODE_PROPERTY_EXISTENCE_CONSTRAINT("Node property existence constraint"),
        RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT("Relationship property existence constraint");

        private static final Kind[] ALL;
        private final String userString;
        private static SchemaComputer<Kind> existenceKindMapper;

        private Kind(String userString) {
            this.userString = userString;
        }

        public byte id() {
            return (byte)(this.ordinal() + 1);
        }

        public String userString() {
            return this.userString;
        }

        public static Kind forId(byte id) throws MalformedSchemaRuleException {
            if (id >= 1 && id <= ALL.length) {
                return Kind.values()[id - 1];
            }
            throw new MalformedSchemaRuleException(null, "Unknown kind id %d", id);
        }

        public static Kind map(IndexDescriptor descriptor) {
            switch (descriptor.type()) {
                case GENERAL: {
                    return INDEX_RULE;
                }
                case UNIQUE: {
                    return CONSTRAINT_INDEX_RULE;
                }
            }
            throw new IllegalStateException("Cannot map descriptor type to legacy schema rule: " + (Object)((Object)descriptor.type()));
        }

        public static Kind map(ConstraintDescriptor descriptor) {
            switch (descriptor.type()) {
                case UNIQUE: {
                    return UNIQUENESS_CONSTRAINT;
                }
                case EXISTS: {
                    return (Kind)((Object)descriptor.schema().computeWith(existenceKindMapper));
                }
            }
            throw new IllegalStateException("Cannot map descriptor type to legacy schema rule: " + descriptor.type());
        }

        static {
            ALL = Kind.values();
            existenceKindMapper = new SchemaComputer<Kind>(){

                public Kind computeSpecific(LabelSchemaDescriptor schema) {
                    return NODE_PROPERTY_EXISTENCE_CONSTRAINT;
                }

                public Kind computeSpecific(RelationTypeSchemaDescriptor schema) {
                    return RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT;
                }

                public Kind computeSpecific(SchemaDescriptor schema) {
                    throw new IllegalStateException("General schema rules cannot support constraints");
                }
            };
        }
    }
}

