/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.collections.api.map.primitive.MutableIntLongMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntLongHashMap;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureLookup;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureVisitor;
import org.neo4j.storageengine.api.EntityType;

public class DbStructureCollector
implements DbStructureVisitor {
    private final TokenMap labels = new TokenMap("label");
    private final TokenMap propertyKeys = new TokenMap("property key");
    private final TokenMap relationshipTypes = new TokenMap("relationship types");
    private final IndexDescriptorMap regularIndices = new IndexDescriptorMap("regular");
    private final IndexDescriptorMap uniqueIndices = new IndexDescriptorMap("unique");
    private final Set<UniquenessConstraintDescriptor> uniquenessConstraints = new HashSet<UniquenessConstraintDescriptor>();
    private final Set<NodeExistenceConstraintDescriptor> nodePropertyExistenceConstraints = new HashSet<NodeExistenceConstraintDescriptor>();
    private final Set<RelExistenceConstraintDescriptor> relPropertyExistenceConstraints = new HashSet<RelExistenceConstraintDescriptor>();
    private final Set<NodeKeyConstraintDescriptor> nodeKeyConstraints = new HashSet<NodeKeyConstraintDescriptor>();
    private final MutableIntLongMap nodeCounts = new IntLongHashMap();
    private final Map<RelSpecifier, Long> relCounts = new HashMap<RelSpecifier, Long>();
    private long allNodesCount = -1L;

    public DbStructureLookup lookup() {
        return new DbStructureLookup(){

            @Override
            public Iterator<Pair<Integer, String>> labels() {
                return DbStructureCollector.this.labels.iterator();
            }

            @Override
            public Iterator<Pair<Integer, String>> properties() {
                return DbStructureCollector.this.propertyKeys.iterator();
            }

            @Override
            public Iterator<Pair<Integer, String>> relationshipTypes() {
                return DbStructureCollector.this.relationshipTypes.iterator();
            }

            @Override
            public Iterator<Pair<String[], String[]>> knownIndices() {
                return DbStructureCollector.this.regularIndices.iterator();
            }

            @Override
            public Iterator<Pair<String[], String[]>> knownUniqueIndices() {
                return DbStructureCollector.this.uniqueIndices.iterator();
            }

            @Override
            public Iterator<Pair<String, String[]>> knownUniqueConstraints() {
                return this.idsToNames(DbStructureCollector.this.uniquenessConstraints);
            }

            @Override
            public Iterator<Pair<String, String[]>> knownNodePropertyExistenceConstraints() {
                return this.idsToNames(DbStructureCollector.this.nodePropertyExistenceConstraints);
            }

            @Override
            public Iterator<Pair<String, String[]>> knownNodeKeyConstraints() {
                return this.idsToNames(DbStructureCollector.this.nodeKeyConstraints);
            }

            @Override
            public long nodesAllCardinality() {
                return DbStructureCollector.this.allNodesCount;
            }

            @Override
            public Iterator<Pair<String, String[]>> knownRelationshipPropertyExistenceConstraints() {
                return Iterators.map(relConstraint -> {
                    String label = DbStructureCollector.this.labels.byIdOrFail(relConstraint.schema().getRelTypeId());
                    String[] propertyKeyNames = DbStructureCollector.this.propertyKeys.byIdOrFail(relConstraint.schema().getPropertyIds());
                    return Pair.of((Object)label, (Object)propertyKeyNames);
                }, DbStructureCollector.this.relPropertyExistenceConstraints.iterator());
            }

            @Override
            public long nodesWithLabelCardinality(int labelId) {
                return DbStructureCollector.this.nodeCounts.getIfAbsent(labelId, 0L);
            }

            @Override
            public long cardinalityByLabelsAndRelationshipType(int fromLabelId, int relTypeId, int toLabelId) {
                RelSpecifier specifier = new RelSpecifier(fromLabelId, relTypeId, toLabelId);
                Long result = (Long)DbStructureCollector.this.relCounts.get(specifier);
                return result == null ? 0L : result;
            }

            @Override
            public double indexSelectivity(int labelId, int ... propertyKeyIds) {
                LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds);
                IndexStatistics result1 = DbStructureCollector.this.regularIndices.getIndex((SchemaDescriptor)descriptor);
                IndexStatistics result2 = result1 == null ? DbStructureCollector.this.uniqueIndices.getIndex((SchemaDescriptor)descriptor) : result1;
                return result2 == null ? Double.NaN : result2.uniqueValuesPercentage;
            }

            @Override
            public double indexPropertyExistsSelectivity(int labelId, int ... propertyKeyIds) {
                LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds);
                IndexStatistics result1 = DbStructureCollector.this.regularIndices.getIndex((SchemaDescriptor)descriptor);
                IndexStatistics result2 = result1 == null ? DbStructureCollector.this.uniqueIndices.getIndex((SchemaDescriptor)descriptor) : result1;
                return result2 == null ? Double.NaN : (double)result2.size;
            }

            private Iterator<Pair<String, String[]>> idsToNames(Iterable<? extends LabelSchemaSupplier> nodeConstraints) {
                return Iterators.map(nodeConstraint -> {
                    String label = DbStructureCollector.this.labels.byIdOrFail(nodeConstraint.schema().getLabelId());
                    String[] propertyKeyNames = DbStructureCollector.this.propertyKeys.byIdOrFail(nodeConstraint.schema().getPropertyIds());
                    return Pair.of((Object)label, (Object)propertyKeyNames);
                }, nodeConstraints.iterator());
            }
        };
    }

    @Override
    public void visitLabel(int labelId, String labelName) {
        this.labels.putToken(labelId, labelName);
    }

    @Override
    public void visitPropertyKey(int propertyKeyId, String propertyKeyName) {
        this.propertyKeys.putToken(propertyKeyId, propertyKeyName);
    }

    @Override
    public void visitRelationshipType(int relTypeId, String relTypeName) {
        this.relationshipTypes.putToken(relTypeId, relTypeName);
    }

    @Override
    public void visitIndex(IndexDescriptor descriptor, String userDescription, double uniqueValuesPercentage, long size) {
        IndexDescriptorMap indices = descriptor.type() == IndexDescriptor.Type.UNIQUE ? this.uniqueIndices : this.regularIndices;
        indices.putIndex(descriptor.schema(), userDescription, uniqueValuesPercentage, size);
    }

    @Override
    public void visitUniqueConstraint(UniquenessConstraintDescriptor constraint, String userDescription) {
        if (!this.uniquenessConstraints.add(constraint)) {
            throw new IllegalArgumentException(String.format("Duplicated unique constraint %s for %s", constraint, userDescription));
        }
    }

    @Override
    public void visitNodePropertyExistenceConstraint(NodeExistenceConstraintDescriptor constraint, String userDescription) {
        if (!this.nodePropertyExistenceConstraints.add(constraint)) {
            throw new IllegalArgumentException(String.format("Duplicated node property existence constraint %s for %s", constraint, userDescription));
        }
    }

    @Override
    public void visitRelationshipPropertyExistenceConstraint(RelExistenceConstraintDescriptor constraint, String userDescription) {
        if (!this.relPropertyExistenceConstraints.add(constraint)) {
            throw new IllegalArgumentException(String.format("Duplicated relationship property existence constraint %s for %s", constraint, userDescription));
        }
    }

    @Override
    public void visitNodeKeyConstraint(NodeKeyConstraintDescriptor constraint, String userDescription) {
        if (!this.nodeKeyConstraints.add(constraint)) {
            throw new IllegalArgumentException(String.format("Duplicated node key constraint %s for %s", constraint, userDescription));
        }
    }

    @Override
    public void visitAllNodesCount(long nodeCount) {
        if (this.allNodesCount >= 0L) {
            throw new IllegalStateException("Already received node count");
        }
        this.allNodesCount = nodeCount;
    }

    @Override
    public void visitNodeCount(int labelId, String labelName, long nodeCount) {
        if (this.nodeCounts.containsKey(labelId)) {
            throw new IllegalArgumentException(String.format("Duplicate node count %s for label with id %s", nodeCount, labelName));
        }
        this.nodeCounts.put(labelId, nodeCount);
    }

    @Override
    public void visitRelCount(int startLabelId, int relTypeId, int endLabelId, String relCountQuery, long relCount) {
        RelSpecifier specifier = new RelSpecifier(startLabelId, relTypeId, endLabelId);
        if (this.relCounts.put(specifier, relCount) != null) {
            throw new IllegalArgumentException(String.format("Duplicate rel count %s for relationship specifier %s (corresponding query: %s)", relCount, specifier, relCountQuery));
        }
    }

    private static class TokenMap
    implements Iterable<Pair<Integer, String>> {
        private final String tokenType;
        private final Map<Integer, String> forward = new HashMap<Integer, String>();
        private final Map<String, Integer> backward = new HashMap<String, Integer>();

        TokenMap(String tokenType) {
            this.tokenType = tokenType;
        }

        public String byIdOrFail(int token) {
            String result = this.forward.get(token);
            if (result == null) {
                throw new IllegalArgumentException(String.format("Didn't find %s token with id %s", this.tokenType, token));
            }
            return result;
        }

        public String[] byIdOrFail(int[] tokens) {
            String[] results = new String[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                results[i] = this.byIdOrFail(tokens[i]);
            }
            return results;
        }

        public void putToken(int token, String name) {
            if (this.forward.containsKey(token)) {
                throw new IllegalArgumentException(String.format("Duplicate id %s for name %s in %s token map", token, name, this.tokenType));
            }
            if (this.backward.containsKey(name)) {
                throw new IllegalArgumentException(String.format("Duplicate name %s for id %s in %s token map", name, token, this.tokenType));
            }
            this.forward.put(token, name);
            this.backward.put(name, token);
        }

        @Override
        public Iterator<Pair<Integer, String>> iterator() {
            final Iterator<Map.Entry<Integer, String>> iterator = this.forward.entrySet().iterator();
            return new Iterator<Pair<Integer, String>>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Pair<Integer, String> next() {
                    Map.Entry next = (Map.Entry)iterator.next();
                    return Pair.of(next.getKey(), next.getValue());
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }
    }

    private class IndexDescriptorMap
    implements Iterable<Pair<String[], String[]>> {
        private final String indexType;
        private final Map<SchemaDescriptor, IndexStatistics> indexMap = new HashMap<SchemaDescriptor, IndexStatistics>();

        IndexDescriptorMap(String indexType) {
            this.indexType = indexType;
        }

        public void putIndex(SchemaDescriptor descriptor, String userDescription, double uniqueValuesPercentage, long size) {
            if (this.indexMap.containsKey(descriptor)) {
                throw new IllegalArgumentException(String.format("Duplicate index descriptor %s for %s index %s", descriptor, this.indexType, userDescription));
            }
            this.indexMap.put(descriptor, new IndexStatistics(uniqueValuesPercentage, size));
        }

        public IndexStatistics getIndex(SchemaDescriptor descriptor) {
            return this.indexMap.get(descriptor);
        }

        @Override
        public Iterator<Pair<String[], String[]>> iterator() {
            final Iterator<SchemaDescriptor> iterator = this.indexMap.keySet().iterator();
            return new Iterator<Pair<String[], String[]>>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Pair<String[], String[]> next() {
                    String[] entityTokens;
                    SchemaDescriptor next = (SchemaDescriptor)iterator.next();
                    EntityType type = next.entityType();
                    switch (type) {
                        case NODE: {
                            entityTokens = DbStructureCollector.this.labels.byIdOrFail(next.getEntityTokenIds());
                            break;
                        }
                        case RELATIONSHIP: {
                            entityTokens = DbStructureCollector.this.relationshipTypes.byIdOrFail(next.getEntityTokenIds());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Indexing is not supported for EntityType: " + type);
                        }
                    }
                    String[] propertyKeyNames = DbStructureCollector.this.propertyKeys.byIdOrFail(next.getPropertyIds());
                    return Pair.of((Object)entityTokens, (Object)propertyKeyNames);
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }
    }

    private static class IndexStatistics {
        private final double uniqueValuesPercentage;
        private final long size;

        private IndexStatistics(double uniqueValuesPercentage, long size) {
            this.uniqueValuesPercentage = uniqueValuesPercentage;
            this.size = size;
        }
    }

    private static class RelSpecifier {
        public final int fromLabelId;
        public final int relTypeId;
        public final int toLabelId;

        RelSpecifier(int fromLabelId, int relTypeId, int toLabelId) {
            this.fromLabelId = fromLabelId;
            this.relTypeId = relTypeId;
            this.toLabelId = toLabelId;
        }

        public String toString() {
            return String.format("RelSpecifier{fromLabelId=%d, relTypeId=%d, toLabelId=%d}", this.fromLabelId, this.relTypeId, this.toLabelId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelSpecifier that = (RelSpecifier)o;
            return this.fromLabelId == that.fromLabelId && this.relTypeId == that.relTypeId && this.toLabelId == that.toLabelId;
        }

        public int hashCode() {
            int result = this.fromLabelId;
            result = 31 * result + this.relTypeId;
            result = 31 * result + this.toLabelId;
            return result;
        }
    }
}

