/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Iterator;
import java.util.LinkedList;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.PrefetchingIterator;

class TraversalBranchImpl
implements TraversalBranch {
    final TraversalBranch parent;
    private final Relationship howIGotHere;
    private final Node source;
    private ResourceIterator<Relationship> relationships;
    private int depthAndEvaluationBits;
    private int expandedCount;

    TraversalBranchImpl(TraversalBranch parent, int depth, Node source, Relationship toHere) {
        this.parent = parent;
        this.source = source;
        this.howIGotHere = toHere;
        this.depthAndEvaluationBits = depth;
    }

    TraversalBranchImpl(TraversalBranch parent, Node source) {
        this.parent = parent;
        this.source = source;
        this.howIGotHere = null;
        this.depthAndEvaluationBits = 0;
    }

    protected void setEvaluation(Evaluation evaluation) {
        this.depthAndEvaluationBits &= 0x3FFFFFFF;
        this.depthAndEvaluationBits |= this.bitValue(evaluation.includes(), 30) | this.bitValue(evaluation.continues(), 31);
    }

    private int bitValue(boolean value, int bit) {
        return (value ? 1 : 0) << bit;
    }

    protected void expandRelationships(PathExpander expander) {
        if (this.continues()) {
            this.relationships = this.expandRelationshipsWithoutChecks(expander);
        } else {
            this.resetRelationships();
        }
    }

    protected ResourceIterator expandRelationshipsWithoutChecks(PathExpander expander) {
        return Iterators.asResourceIterator(expander.expand((Path)this, BranchState.NO_STATE).iterator());
    }

    protected boolean hasExpandedRelationships() {
        return this.relationships != null;
    }

    protected void evaluate(TraversalContext context) {
        this.setEvaluation(context.evaluate((TraversalBranch)this, null));
    }

    public void initialize(PathExpander expander, TraversalContext metadata) {
        this.evaluate(metadata);
    }

    public TraversalBranch next(PathExpander expander, TraversalContext context) {
        if (this.relationships == null) {
            this.expandRelationships(expander);
        }
        while (this.relationships.hasNext()) {
            Relationship relationship = (Relationship)this.relationships.next();
            if (relationship.equals(this.howIGotHere)) {
                context.unnecessaryRelationshipTraversed();
                continue;
            }
            ++this.expandedCount;
            Node node = relationship.getOtherNode(this.source);
            TraversalBranch next = this.newNextBranch(node, relationship);
            if (context.isUnique(next)) {
                context.relationshipTraversed();
                next.initialize(expander, context);
                return next;
            }
            context.unnecessaryRelationshipTraversed();
        }
        this.resetRelationships();
        return null;
    }

    protected TraversalBranch newNextBranch(Node node, Relationship relationship) {
        return new TraversalBranchImpl(this, this.length() + 1, node, relationship);
    }

    public void prune() {
        this.resetRelationships();
    }

    private void resetRelationships() {
        if (this.relationships != null) {
            this.relationships.close();
        }
        this.relationships = Iterators.emptyResourceIterator();
    }

    public int length() {
        return this.depthAndEvaluationBits & 0x3FFFFFFF;
    }

    public TraversalBranch parent() {
        return this.parent;
    }

    public int expanded() {
        return this.expandedCount;
    }

    public boolean includes() {
        return (this.depthAndEvaluationBits & 0x40000000) != 0;
    }

    public boolean continues() {
        return (this.depthAndEvaluationBits & Integer.MIN_VALUE) != 0;
    }

    public void evaluation(Evaluation eval) {
        this.setEvaluation(Evaluation.of((boolean)(this.includes() & eval.includes()), (boolean)(this.continues() & eval.continues())));
    }

    public Node startNode() {
        return this.findStartBranch().endNode();
    }

    private TraversalBranch findStartBranch() {
        TraversalBranchImpl branch = this;
        while (branch.length() > 0) {
            branch = branch.parent();
        }
        return branch;
    }

    public Node endNode() {
        return this.source;
    }

    public Relationship lastRelationship() {
        return this.howIGotHere;
    }

    public Iterable<Relationship> relationships() {
        LinkedList<Relationship> relationships = new LinkedList<Relationship>();
        TraversalBranchImpl branch = this;
        while (branch.length() > 0) {
            relationships.addFirst(branch.lastRelationship());
            branch = branch.parent();
        }
        return relationships;
    }

    public Iterable<Relationship> reverseRelationships() {
        return () -> new PrefetchingIterator<Relationship>(){
            private TraversalBranch branch;
            {
                this.branch = TraversalBranchImpl.this;
            }

            protected Relationship fetchNextOrNull() {
                Relationship relationship;
                try {
                    relationship = this.branch != null ? this.branch.lastRelationship() : null;
                    this.branch = this.branch != null ? this.branch.parent() : null;
                }
                catch (Throwable throwable) {
                    this.branch = this.branch != null ? this.branch.parent() : null;
                    throw throwable;
                }
                return relationship;
            }
        };
    }

    public Iterable<Node> nodes() {
        LinkedList<Node> nodes = new LinkedList<Node>();
        TraversalBranchImpl branch = this;
        while (branch.length() > 0) {
            nodes.addFirst(branch.endNode());
            branch = branch.parent();
        }
        nodes.addFirst(branch.endNode());
        return nodes;
    }

    public Iterable<Node> reverseNodes() {
        return () -> new PrefetchingIterator<Node>(){
            private TraversalBranch branch;
            {
                this.branch = TraversalBranchImpl.this;
            }

            protected Node fetchNextOrNull() {
                try {
                    Node node = this.branch.length() >= 0 ? this.branch.endNode() : null;
                    return node;
                }
                finally {
                    this.branch = this.branch.parent();
                }
            }
        };
    }

    public Iterator<PropertyContainer> iterator() {
        LinkedList<Object> entities = new LinkedList<Object>();
        TraversalBranchImpl branch = this;
        while (branch.length() > 0) {
            entities.addFirst(branch.endNode());
            entities.addFirst(branch.lastRelationship());
            branch = branch.parent();
        }
        entities.addFirst(branch.endNode());
        return entities.iterator();
    }

    public int hashCode() {
        TraversalBranchImpl branch = this;
        int hashCode = 1;
        while (branch.length() > 0) {
            Relationship relationship = branch.lastRelationship();
            hashCode = 31 * hashCode + relationship.hashCode();
            branch = branch.parent();
        }
        if (hashCode == 1) {
            hashCode = this.endNode().hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TraversalBranch)) {
            return false;
        }
        TraversalBranchImpl branch = this;
        TraversalBranch other = (TraversalBranch)obj;
        if (branch.length() != other.length()) {
            return false;
        }
        while (branch.length() > 0) {
            if (!branch.lastRelationship().equals(other.lastRelationship())) {
                return false;
            }
            branch = branch.parent();
            other = other.parent();
        }
        return true;
    }

    public String toString() {
        return Paths.defaultPathToString((Path)this);
    }

    public Object state() {
        return null;
    }
}

