/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.StoreIndexDescriptor;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaRuleAccess;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaStorage
implements SchemaRuleAccess {
    private final RecordStore<DynamicRecord> schemaStore;

    public SchemaStorage(RecordStore<DynamicRecord> schemaStore) {
        this.schemaStore = schemaStore;
    }

    public StoreIndexDescriptor indexGetForSchema(IndexDescriptor descriptor) {
        Iterator<StoreIndexDescriptor> indexes = this.loadAllSchemaRules(descriptor::equals, StoreIndexDescriptor.class, false);
        StoreIndexDescriptor foundRule = null;
        while (indexes.hasNext()) {
            StoreIndexDescriptor candidate = indexes.next();
            if (foundRule != null) {
                throw new IllegalStateException(String.format("Found more than one matching index, %s and %s", foundRule, candidate));
            }
            foundRule = candidate;
        }
        return foundRule;
    }

    public Iterator<StoreIndexDescriptor> indexesGetAll() {
        return this.loadAllSchemaRules(Predicates.alwaysTrue(), StoreIndexDescriptor.class, false);
    }

    public Iterator<ConstraintRule> constraintsGetAll() {
        return this.loadAllSchemaRules(Predicates.alwaysTrue(), ConstraintRule.class, false);
    }

    public Iterator<ConstraintRule> constraintsGetAllIgnoreMalformed() {
        return this.loadAllSchemaRules(Predicates.alwaysTrue(), ConstraintRule.class, true);
    }

    public Iterator<ConstraintRule> constraintsGetForRelType(int relTypeId) {
        return this.loadAllSchemaRules(rule -> SchemaDescriptorPredicates.hasRelType((SchemaDescriptorSupplier)rule, (int)relTypeId), ConstraintRule.class, false);
    }

    public Iterator<ConstraintRule> constraintsGetForLabel(int labelId) {
        return this.loadAllSchemaRules(rule -> SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)rule, (int)labelId), ConstraintRule.class, false);
    }

    public Iterator<ConstraintRule> constraintsGetForSchema(SchemaDescriptor schemaDescriptor) {
        return this.loadAllSchemaRules(SchemaDescriptor.equalTo((SchemaDescriptor)schemaDescriptor), ConstraintRule.class, false);
    }

    public ConstraintRule constraintsGetSingle(ConstraintDescriptor descriptor) throws SchemaRuleNotFoundException, DuplicateSchemaRuleException {
        Iterator<ConstraintRule> rules = this.loadAllSchemaRules(arg_0 -> ((ConstraintDescriptor)descriptor).isSame(arg_0), ConstraintRule.class, false);
        if (!rules.hasNext()) {
            throw new SchemaRuleNotFoundException(SchemaRule.Kind.map(descriptor), descriptor.schema());
        }
        ConstraintRule rule = rules.next();
        if (rules.hasNext()) {
            throw new DuplicateSchemaRuleException(SchemaRule.Kind.map(descriptor), descriptor.schema());
        }
        return rule;
    }

    public Iterator<SchemaRule> loadAllSchemaRules() {
        return this.loadAllSchemaRules(Predicates.alwaysTrue(), SchemaRule.class, false);
    }

    @Override
    public SchemaRule loadSingleSchemaRule(long ruleId) throws MalformedSchemaRuleException {
        List<DynamicRecord> records;
        try {
            records = this.schemaStore.getRecords(ruleId, RecordLoad.NORMAL);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException(e.getMessage(), e);
        }
        return SchemaStore.readSchemaRule(ruleId, records, this.newRecordBuffer());
    }

    <ReturnType extends SchemaRule> Iterator<ReturnType> loadAllSchemaRules(final Predicate<ReturnType> predicate, final Class<ReturnType> returnType, final boolean ignoreMalformed) {
        return new PrefetchingIterator<ReturnType>(){
            private final long highestId;
            private long currentId;
            private final byte[] scratchData;
            private final DynamicRecord record;
            {
                this.highestId = SchemaStorage.this.schemaStore.getHighestPossibleIdInUse();
                this.currentId = 1L;
                this.scratchData = SchemaStorage.this.newRecordBuffer();
                this.record = (DynamicRecord)SchemaStorage.this.schemaStore.newRecord();
            }

            protected ReturnType fetchNextOrNull() {
                while (this.currentId <= this.highestId) {
                    long id;
                    ++this.currentId;
                    SchemaStorage.this.schemaStore.getRecord(id, this.record, RecordLoad.FORCE);
                    if (!this.record.inUse() || !this.record.isStartRecord()) continue;
                    try {
                        SchemaRule returnRule;
                        List<DynamicRecord> records;
                        try {
                            records = SchemaStorage.this.schemaStore.getRecords(id, RecordLoad.NORMAL);
                        }
                        catch (InvalidRecordException e) {
                            continue;
                        }
                        SchemaRule schemaRule = SchemaStore.readSchemaRule(id, records, this.scratchData);
                        if (!returnType.isInstance(schemaRule) || !predicate.test(returnRule = (SchemaRule)returnType.cast(schemaRule))) continue;
                        return returnRule;
                    }
                    catch (MalformedSchemaRuleException e) {
                        if (ignoreMalformed) continue;
                        throw new RuntimeException((Throwable)((Object)e));
                    }
                }
                return null;
            }
        };
    }

    public long newRuleId() {
        return this.schemaStore.nextId();
    }

    private byte[] newRecordBuffer() {
        return new byte[this.schemaStore.getRecordSize() * 4];
    }
}

