/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.ArrayList;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;

public class FusionIndexSampler
implements IndexSampler {
    private final Iterable<IndexSampler> samplers;

    public FusionIndexSampler(Iterable<IndexSampler> samplers) {
        this.samplers = samplers;
    }

    @Override
    public IndexSample sampleIndex() throws IndexNotFoundKernelException {
        ArrayList<IndexSample> samples = new ArrayList<IndexSample>();
        Exception exception = null;
        for (IndexSampler sampler : this.samplers) {
            try {
                samples.add(sampler.sampleIndex());
            }
            catch (RuntimeException | IndexNotFoundKernelException e) {
                exception = (Exception)Exceptions.chain(exception, (Throwable)e);
            }
        }
        if (exception != null) {
            Exceptions.throwIfUnchecked(exception);
            throw (IndexNotFoundKernelException)((Object)exception);
        }
        return FusionIndexSampler.combineSamples(samples);
    }

    public static IndexSample combineSamples(Iterable<IndexSample> samples) {
        long indexSize = 0L;
        long uniqueValues = 0L;
        long sampleSize = 0L;
        for (IndexSample sample : samples) {
            indexSize += sample.indexSize();
            uniqueValues += sample.uniqueValues();
            sampleSize += sample.sampleSize();
        }
        return new IndexSample(indexSize, uniqueValues, sampleSize);
    }
}

