/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;
import org.neo4j.values.storable.Value;

class PropertyContainerStateImpl
implements PropertyContainerState {
    private final CollectionsFactory collectionsFactory;
    private final long id;
    private MutableLongObjectMap<Value> addedProperties;
    private MutableLongObjectMap<Value> changedProperties;
    private MutableLongSet removedProperties;

    PropertyContainerStateImpl(long id, CollectionsFactory collectionsFactory) {
        this.id = id;
        this.collectionsFactory = Objects.requireNonNull(collectionsFactory);
    }

    public long getId() {
        return this.id;
    }

    void clear() {
        if (this.changedProperties != null) {
            this.changedProperties.clear();
        }
        if (this.addedProperties != null) {
            this.addedProperties.clear();
        }
        if (this.removedProperties != null) {
            this.removedProperties.clear();
        }
    }

    void changeProperty(int propertyKeyId, Value value) {
        if (this.addedProperties != null && this.addedProperties.containsKey((long)propertyKeyId)) {
            this.addedProperties.put((long)propertyKeyId, (Object)value);
            return;
        }
        if (this.changedProperties == null) {
            this.changedProperties = this.collectionsFactory.newValuesMap();
        }
        this.changedProperties.put((long)propertyKeyId, (Object)value);
        if (this.removedProperties != null) {
            this.removedProperties.remove((long)propertyKeyId);
        }
    }

    void addProperty(int propertyKeyId, Value value) {
        if (this.removedProperties != null && this.removedProperties.remove((long)propertyKeyId)) {
            this.changeProperty(propertyKeyId, value);
            return;
        }
        if (this.addedProperties == null) {
            this.addedProperties = this.collectionsFactory.newValuesMap();
        }
        this.addedProperties.put((long)propertyKeyId, (Object)value);
    }

    void removeProperty(int propertyKeyId) {
        if (this.addedProperties != null && this.addedProperties.remove((long)propertyKeyId) != null) {
            return;
        }
        if (this.removedProperties == null) {
            this.removedProperties = this.collectionsFactory.newLongSet();
        }
        this.removedProperties.add((long)propertyKeyId);
        if (this.changedProperties != null) {
            this.changedProperties.remove((long)propertyKeyId);
        }
    }

    @Override
    public Iterator<StorageProperty> addedProperties() {
        return this.toPropertyIterator((LongObjectMap<Value>)this.addedProperties);
    }

    @Override
    public Iterator<StorageProperty> changedProperties() {
        return this.toPropertyIterator((LongObjectMap<Value>)this.changedProperties);
    }

    @Override
    public IntIterable removedProperties() {
        return this.removedProperties == null ? IntSets.immutable.empty() : this.removedProperties.asLazy().collectInt(Math::toIntExact);
    }

    @Override
    public Iterator<StorageProperty> addedAndChangedProperties() {
        if (this.addedProperties == null) {
            return this.toPropertyIterator((LongObjectMap<Value>)this.changedProperties);
        }
        if (this.changedProperties == null) {
            return this.toPropertyIterator((LongObjectMap<Value>)this.addedProperties);
        }
        return Iterators.concat((Iterator[])new Iterator[]{this.toPropertyIterator((LongObjectMap<Value>)this.addedProperties), this.toPropertyIterator((LongObjectMap<Value>)this.changedProperties)});
    }

    @Override
    public boolean hasPropertyChanges() {
        return this.addedProperties != null || this.removedProperties != null || this.changedProperties != null;
    }

    @Override
    public boolean isPropertyChangedOrRemoved(int propertyKey) {
        return this.removedProperties != null && this.removedProperties.contains((long)propertyKey) || this.changedProperties != null && this.changedProperties.containsKey((long)propertyKey);
    }

    private Iterator<StorageProperty> toPropertyIterator(LongObjectMap<Value> propertyMap) {
        return propertyMap == null ? Collections.emptyIterator() : propertyMap.keyValuesView().collect((Function & Serializable)e -> new PropertyKeyValue(Math.toIntExact(e.getOne()), (Value)e.getTwo())).iterator();
    }
}

