/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.index.FlipFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.schema.index.CapableIndexDescriptor;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.BatchingMultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.util.FeatureToggles;

public class MultipleIndexPopulator
implements IndexPopulator {
    public static final String QUEUE_THRESHOLD_NAME = "queue_threshold";
    static final String BATCH_SIZE_NAME = "batch_size";
    private final int QUEUE_THRESHOLD = FeatureToggles.getInteger(this.getClass(), (String)"queue_threshold", (int)20000);
    private final int BATCH_SIZE = FeatureToggles.getInteger(BatchingMultipleIndexPopulator.class, (String)"batch_size", (int)10000);
    final Queue<IndexEntryUpdate<?>> updatesQueue = new LinkedBlockingQueue();
    final List<IndexPopulation> populations = new CopyOnWriteArrayList<IndexPopulation>();
    private final IndexStoreView storeView;
    private final LogProvider logProvider;
    protected final Log log;
    private final EntityType type;
    private final SchemaState schemaState;
    private StoreScan<IndexPopulationFailedKernelException> storeScan;

    public MultipleIndexPopulator(IndexStoreView storeView, LogProvider logProvider, EntityType type, SchemaState schemaState) {
        this.storeView = storeView;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(IndexPopulationJob.class);
        this.type = type;
        this.schemaState = schemaState;
    }

    IndexPopulation addPopulator(IndexPopulator populator, CapableIndexDescriptor capableIndexDescriptor, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory, String indexUserDescription) {
        IndexPopulation population = this.createPopulation(populator, capableIndexDescriptor, flipper, failedIndexProxyFactory, indexUserDescription);
        this.populations.add(population);
        return population;
    }

    private IndexPopulation createPopulation(IndexPopulator populator, CapableIndexDescriptor capableIndexDescriptor, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory, String indexUserDescription) {
        return new IndexPopulation(populator, capableIndexDescriptor, flipper, failedIndexProxyFactory, indexUserDescription);
    }

    boolean hasPopulators() {
        return !this.populations.isEmpty();
    }

    @Override
    public void create() {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> {
            this.log.info("Index population started: [%s]", new Object[]{((IndexPopulation)population).indexUserDescription});
            population.create();
        }));
    }

    @Override
    public void drop() {
        throw new UnsupportedOperationException("Can't drop indexes from this populator implementation");
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
        throw new UnsupportedOperationException("Can't populate directly using this populator implementation. ");
    }

    public StoreScan<IndexPopulationFailedKernelException> indexAllEntities() {
        int[] entityTokenIds = this.entityTokenIds();
        int[] propertyKeyIds = this.propertyKeyIds();
        IntPredicate propertyKeyIdFilter = propertyKeyId -> ArrayIterate.contains((int[])propertyKeyIds, (int)propertyKeyId);
        this.storeScan = this.type == EntityType.RELATIONSHIP ? this.storeView.visitRelationships(entityTokenIds, propertyKeyIdFilter, new EntityPopulationVisitor()) : this.storeView.visitNodes(entityTokenIds, propertyKeyIdFilter, new EntityPopulationVisitor(), null, false);
        return new DelegatingStoreScan<IndexPopulationFailedKernelException>(this.storeScan){

            @Override
            public void run() throws IndexPopulationFailedKernelException {
                super.run();
                MultipleIndexPopulator.this.flushAll();
            }
        };
    }

    public void queueUpdate(IndexEntryUpdate<?> update) {
        this.updatesQueue.add(update);
    }

    public void fail(Throwable failure) {
        for (IndexPopulation population : this.populations) {
            this.fail(population, failure);
        }
    }

    protected void fail(IndexPopulation population, Throwable failure) {
        Throwable cause;
        if (!this.removeFromOngoingPopulations(population)) {
            return;
        }
        if (failure instanceof IndexPopulationFailedKernelException && (cause = failure.getCause()) instanceof IndexEntryConflictException) {
            failure = cause;
        }
        if (!(failure instanceof IndexEntryConflictException)) {
            this.log.error(String.format("Failed to populate index: [%s]", population.indexUserDescription), failure);
        }
        IndexPopulationFailure indexPopulationFailure = IndexPopulationFailure.failure(failure);
        population.flipToFailed(indexPopulationFailure);
        try {
            population.populator.markAsFailed(indexPopulationFailure.asString());
            population.populator.close(false);
        }
        catch (Throwable e) {
            this.log.error(String.format("Unable to close failed populator for index: [%s]", population.indexUserDescription), e);
        }
    }

    @Override
    public void verifyDeferredConstraints(NodePropertyAccessor accessor) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    @Override
    public MultipleIndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
        HashMap<SchemaDescriptor, Pair<IndexPopulation, IndexUpdater>> updaters = new HashMap<SchemaDescriptor, Pair<IndexPopulation, IndexUpdater>>();
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> {
            IndexUpdater updater = population.populator.newPopulatingUpdater(accessor);
            updaters.put(population.schema(), Pair.of((Object)population, (Object)updater));
        }));
        return new MultipleIndexUpdater(this, updaters, this.logProvider);
    }

    @Override
    public void close(boolean populationCompletedSuccessfully) {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> population.populator.close(populationCompletedSuccessfully)));
    }

    @Override
    public void markAsFailed(String failure) {
        throw new UnsupportedOperationException("Multiple index populator can't be marked as failed.");
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        throw new UnsupportedOperationException("Multiple index populator can't perform index sampling.");
    }

    @Override
    public IndexSample sampleResult() {
        throw new UnsupportedOperationException("Multiple index populator can't perform index sampling.");
    }

    void resetIndexCounts() {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)this::resetIndexCountsForPopulation));
    }

    private void resetIndexCountsForPopulation(IndexPopulation indexPopulation) {
        this.storeView.replaceIndexCounts(indexPopulation.indexId, 0L, 0L, 0L);
    }

    void flipAfterPopulation(boolean verifyBeforeFlipping) {
        for (IndexPopulation population : this.populations) {
            try {
                population.flip(verifyBeforeFlipping);
            }
            catch (Throwable t) {
                this.fail(population, t);
            }
        }
    }

    private int[] propertyKeyIds() {
        return this.populations.stream().flatMapToInt(this::propertyKeyIds).distinct().toArray();
    }

    private IntStream propertyKeyIds(IndexPopulation population) {
        return IntStream.of(population.schema().getPropertyIds());
    }

    private int[] entityTokenIds() {
        return this.populations.stream().flatMapToInt(population -> Arrays.stream(population.schema().getEntityTokenIds())).toArray();
    }

    public void cancel() {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)this::cancelIndexPopulation));
    }

    void cancelIndexPopulation(IndexPopulation indexPopulation) {
        try {
            indexPopulation.cancel();
        }
        catch (IOException e) {
            this.fail(indexPopulation, e);
        }
    }

    private boolean removeFromOngoingPopulations(IndexPopulation indexPopulation) {
        return this.populations.remove(indexPopulation);
    }

    void populateFromUpdateQueueBatched(long currentlyIndexedNodeId) {
        if (this.isUpdateQueueThresholdReached()) {
            this.populateFromUpdateQueue(currentlyIndexedNodeId);
        }
    }

    private boolean isUpdateQueueThresholdReached() {
        return this.updatesQueue.size() >= this.QUEUE_THRESHOLD;
    }

    protected void populateFromUpdateQueue(long currentlyIndexedNodeId) {
        this.populateFromUpdateQueueIfAvailable(currentlyIndexedNodeId);
    }

    void flushAll() {
        this.populations.forEach(this::flush);
    }

    protected void flush(IndexPopulation population) {
        try {
            population.populator.add(population.takeCurrentBatch());
        }
        catch (Throwable failure) {
            this.fail(population, failure);
        }
    }

    private void populateFromUpdateQueueIfAvailable(long currentlyIndexedNodeId) {
        if (!this.updatesQueue.isEmpty()) {
            try (MultipleIndexUpdater updater = this.newPopulatingUpdater(this.storeView);){
                do {
                    IndexEntryUpdate<?> update = this.updatesQueue.poll();
                    this.storeScan.acceptUpdate(updater, update, currentlyIndexedNodeId);
                } while (!this.updatesQueue.isEmpty());
            }
        }
    }

    private void forEachPopulation(ThrowingConsumer<IndexPopulation, Exception> action) {
        for (IndexPopulation population : this.populations) {
            try {
                action.accept((Object)population);
            }
            catch (Throwable failure) {
                this.fail(population, failure);
            }
        }
    }

    protected static class DelegatingStoreScan<E extends Exception>
    implements StoreScan<E> {
        private final StoreScan<E> delegate;

        DelegatingStoreScan(StoreScan<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() throws E {
            this.delegate.run();
        }

        @Override
        public void stop() {
            this.delegate.stop();
        }

        @Override
        public void acceptUpdate(MultipleIndexUpdater updater, IndexEntryUpdate<?> update, long currentlyIndexedNodeId) {
            this.delegate.acceptUpdate(updater, update, currentlyIndexedNodeId);
        }

        @Override
        public PopulationProgress getProgress() {
            return this.delegate.getProgress();
        }
    }

    private class EntityPopulationVisitor
    implements Visitor<EntityUpdates, IndexPopulationFailedKernelException> {
        private EntityPopulationVisitor() {
        }

        public boolean visit(EntityUpdates updates) {
            this.add(updates);
            MultipleIndexPopulator.this.populateFromUpdateQueueBatched(updates.getEntityId());
            return false;
        }

        private void add(EntityUpdates updates) {
            for (IndexEntryUpdate<IndexPopulation> indexUpdate : updates.forIndexKeys(MultipleIndexPopulator.this.populations)) {
                indexUpdate.indexKey().onUpdate(indexUpdate);
            }
        }
    }

    public class IndexPopulation
    implements SchemaDescriptorSupplier {
        public final IndexPopulator populator;
        final FlippableIndexProxy flipper;
        private final long indexId;
        private final CapableIndexDescriptor capableIndexDescriptor;
        private final IndexCountsRemover indexCountsRemover;
        private final FailedIndexProxyFactory failedIndexProxyFactory;
        private final String indexUserDescription;
        private boolean populationOngoing = true;
        private final ReentrantLock populatorLock = new ReentrantLock();
        List<IndexEntryUpdate<?>> batchedUpdates;

        IndexPopulation(IndexPopulator populator, CapableIndexDescriptor capableIndexDescriptor, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory, String indexUserDescription) {
            this.populator = populator;
            this.capableIndexDescriptor = capableIndexDescriptor;
            this.indexId = capableIndexDescriptor.getId();
            this.flipper = flipper;
            this.failedIndexProxyFactory = failedIndexProxyFactory;
            this.indexUserDescription = indexUserDescription;
            this.indexCountsRemover = new IndexCountsRemover(MultipleIndexPopulator.this.storeView, this.indexId);
            this.batchedUpdates = new ArrayList(MultipleIndexPopulator.this.BATCH_SIZE);
        }

        private void flipToFailed(IndexPopulationFailure failure) {
            this.flipper.flipTo(new FailedIndexProxy(this.capableIndexDescriptor, this.indexUserDescription, this.populator, failure, this.indexCountsRemover, MultipleIndexPopulator.this.logProvider));
        }

        void create() throws IOException {
            this.populatorLock.lock();
            try {
                if (this.populationOngoing) {
                    this.populator.create();
                }
            }
            finally {
                this.populatorLock.unlock();
            }
        }

        void cancel() throws IOException {
            this.populatorLock.lock();
            try {
                if (this.populationOngoing) {
                    this.populator.close(false);
                    MultipleIndexPopulator.this.resetIndexCountsForPopulation(this);
                    MultipleIndexPopulator.this.removeFromOngoingPopulations(this);
                    this.populationOngoing = false;
                }
            }
            finally {
                this.populatorLock.unlock();
            }
        }

        private void onUpdate(IndexEntryUpdate<?> update) {
            this.populator.includeSample(update);
            if (this.batch(update)) {
                MultipleIndexPopulator.this.flush(this);
            }
        }

        void flip(boolean verifyBeforeFlipping) throws FlipFailedKernelException {
            this.flipper.flip(() -> {
                this.populatorLock.lock();
                try {
                    if (this.populationOngoing) {
                        this.populator.add(this.takeCurrentBatch());
                        MultipleIndexPopulator.this.populateFromUpdateQueueIfAvailable(Long.MAX_VALUE);
                        if (MultipleIndexPopulator.this.populations.contains(this)) {
                            if (verifyBeforeFlipping) {
                                this.populator.verifyDeferredConstraints(MultipleIndexPopulator.this.storeView);
                            }
                            IndexSample sample = this.populator.sampleResult();
                            MultipleIndexPopulator.this.storeView.replaceIndexCounts(this.indexId, sample.uniqueValues(), sample.sampleSize(), sample.indexSize());
                            this.populator.close(true);
                            MultipleIndexPopulator.this.schemaState.clear();
                            Boolean bl = true;
                            return bl;
                        }
                    }
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    this.populationOngoing = false;
                    this.populatorLock.unlock();
                }
            }, this.failedIndexProxyFactory);
            MultipleIndexPopulator.this.removeFromOngoingPopulations(this);
            this.logCompletionMessage();
        }

        private void logCompletionMessage() {
            InternalIndexState postPopulationState = this.flipper.getState();
            String messageTemplate = this.isIndexPopulationOngoing(postPopulationState) ? "Index created. Starting data checks. Index [%s] is %s." : "Index creation finished. Index [%s] is %s.";
            MultipleIndexPopulator.this.log.info(messageTemplate, new Object[]{this.indexUserDescription, postPopulationState.name()});
        }

        private boolean isIndexPopulationOngoing(InternalIndexState postPopulationState) {
            return InternalIndexState.POPULATING == postPopulationState;
        }

        public SchemaDescriptor schema() {
            return this.capableIndexDescriptor.schema();
        }

        public boolean batch(IndexEntryUpdate<?> update) {
            this.batchedUpdates.add(update);
            return this.batchedUpdates.size() >= MultipleIndexPopulator.this.BATCH_SIZE;
        }

        Collection<IndexEntryUpdate<?>> takeCurrentBatch() {
            if (this.batchedUpdates.isEmpty()) {
                return Collections.emptyList();
            }
            List<IndexEntryUpdate<?>> batch = this.batchedUpdates;
            this.batchedUpdates = new ArrayList(MultipleIndexPopulator.this.BATCH_SIZE);
            return batch;
        }
    }

    public static class MultipleIndexUpdater
    implements IndexUpdater {
        private final Map<SchemaDescriptor, Pair<IndexPopulation, IndexUpdater>> populationsWithUpdaters;
        private final MultipleIndexPopulator multipleIndexPopulator;
        private final Log log;

        MultipleIndexUpdater(MultipleIndexPopulator multipleIndexPopulator, Map<SchemaDescriptor, Pair<IndexPopulation, IndexUpdater>> populationsWithUpdaters, LogProvider logProvider) {
            this.multipleIndexPopulator = multipleIndexPopulator;
            this.populationsWithUpdaters = populationsWithUpdaters;
            this.log = logProvider.getLog(this.getClass());
        }

        @Override
        public void process(IndexEntryUpdate<?> update) {
            Pair<IndexPopulation, IndexUpdater> pair = this.populationsWithUpdaters.get(update.indexKey().schema());
            if (pair != null) {
                IndexPopulation population = (IndexPopulation)pair.first();
                IndexUpdater updater = (IndexUpdater)pair.other();
                try {
                    population.populator.includeSample(update);
                    updater.process(update);
                }
                catch (Throwable t) {
                    try {
                        updater.close();
                    }
                    catch (Throwable ce) {
                        this.log.error(String.format("Failed to close index updater: [%s]", updater), ce);
                    }
                    this.populationsWithUpdaters.remove(update.indexKey().schema());
                    this.multipleIndexPopulator.fail(population, t);
                }
            }
        }

        @Override
        public void close() {
            for (Pair<IndexPopulation, IndexUpdater> pair : this.populationsWithUpdaters.values()) {
                IndexPopulation population = (IndexPopulation)pair.first();
                IndexUpdater updater = (IndexUpdater)pair.other();
                try {
                    updater.close();
                }
                catch (Throwable t) {
                    this.multipleIndexPopulator.fail(population, t);
                }
            }
            this.populationsWithUpdaters.clear();
        }
    }
}

