/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.internal.KernelDiagnostics;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class DatabaseDiagnostics
extends LifecycleAdapter {
    private final DiagnosticsManager diagnosticsManager;
    private final NeoStoreDataSource neoStoreDataSource;
    private final DatabaseInfo databaseInfo;

    DatabaseDiagnostics(DiagnosticsManager diagnosticsManager, NeoStoreDataSource neoStoreDataSource, DatabaseInfo databaseInfo) {
        this.diagnosticsManager = diagnosticsManager;
        this.neoStoreDataSource = neoStoreDataSource;
        this.databaseInfo = databaseInfo;
    }

    public void start() throws Throwable {
        this.diagnosticsManager.prependProvider(new KernelDiagnostics.Versions(this.databaseInfo, this.neoStoreDataSource.getStoreId()));
        this.neoStoreDataSource.registerDiagnosticsWith(this.diagnosticsManager);
        this.diagnosticsManager.appendProvider(new KernelDiagnostics.StoreFiles(this.neoStoreDataSource.getDatabaseDirectory()));
    }
}

