/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.RecordDataAssembler;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class ReadRecordsStep<RECORD extends AbstractBaseRecord>
extends ProcessorStep<LongIterator> {
    private final RecordStore<RECORD> store;
    private final int batchSize;
    private final RecordDataAssembler<RECORD> assembler;

    public ReadRecordsStep(StageControl control, Configuration config, boolean inRecordWritingStage, RecordStore<RECORD> store) {
        this(control, config, inRecordWritingStage, store, new RecordDataAssembler<AbstractBaseRecord>(store::newRecord));
    }

    public ReadRecordsStep(StageControl control, Configuration config, boolean inRecordWritingStage, RecordStore<RECORD> store, RecordDataAssembler<RECORD> converter) {
        super(control, ">", config, ReadRecordsStep.parallelReading(config, inRecordWritingStage) ? 0 : 1, new StatsProvider[0]);
        this.store = store;
        this.assembler = converter;
        this.batchSize = config.batchSize();
    }

    private static boolean parallelReading(Configuration config, boolean inRecordWritingStage) {
        return inRecordWritingStage && config.highIO() || !inRecordWritingStage && config.parallelRecordReads();
    }

    @Override
    public void start(int orderingGuarantees) {
        super.start(orderingGuarantees | 1);
    }

    @Override
    protected void process(LongIterator idRange, BatchSender sender) {
        if (!idRange.hasNext()) {
            return;
        }
        long id = idRange.next();
        AbstractBaseRecord[] batch = this.control.reuse(() -> this.assembler.newBatchObject(this.batchSize));
        int i = 0;
        try (RecordCursor<AbstractBaseRecord> cursor = this.store.newRecordCursor(batch[0]).acquire(id, RecordLoad.CHECK);){
            boolean hasNext = true;
            while (hasNext) {
                if (this.assembler.append(cursor, batch, id, i)) {
                    ++i;
                }
                if (!(hasNext = idRange.hasNext())) continue;
                id = idRange.next();
            }
        }
        sender.send(this.assembler.cutOffAt(batch, i));
    }
}

