/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.storeview.PropertyAwareEntityStoreScan;

public class RelationshipStoreScan<FAILURE extends Exception>
extends PropertyAwareEntityStoreScan<RelationshipRecord, FAILURE> {
    private final int[] relationshipTypeIds;
    private final Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor;

    public RelationshipStoreScan(RelationshipStore relationshipStore, LockService locks, PropertyStore propertyStore, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, int[] relationshipTypeIds, IntPredicate propertyKeyIdFilter) {
        super(relationshipStore, propertyStore, propertyKeyIdFilter, id -> locks.acquireRelationshipLock(id, LockService.LockType.READ_LOCK));
        this.relationshipTypeIds = relationshipTypeIds;
        this.propertyUpdatesVisitor = propertyUpdatesVisitor;
    }

    @Override
    protected void process(RelationshipRecord record) throws FAILURE {
        EntityUpdates.Builder updates;
        int reltype = record.getType();
        if (this.propertyUpdatesVisitor != null && RelationshipStoreScan.containsAnyEntityToken(this.relationshipTypeIds, reltype) && this.hasRelevantProperty(record, updates = EntityUpdates.forEntity(record.getId()).withTokens(reltype))) {
            this.propertyUpdatesVisitor.visit((Object)updates.build());
        }
    }
}

