/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordRelationshipCursor;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;

class RecordRelationshipScanCursor
extends RecordRelationshipCursor
implements StorageRelationshipScanCursor {
    private int filterType;
    private long next;
    private long highMark;
    private long nextStoreReference;
    private PageCursor pageCursor;
    private boolean open;

    RecordRelationshipScanCursor(RelationshipStore relationshipStore, RelationshipGroupStore groupStore) {
        super(relationshipStore);
    }

    @Override
    public void scan(int type) {
        if (this.getId() != -1L) {
            this.reset();
        }
        if (this.pageCursor == null) {
            this.pageCursor = this.relationshipPage(0L);
        }
        this.next = 0L;
        this.filterType = type;
        this.highMark = this.relationshipHighMark();
        this.nextStoreReference = -1L;
        this.open = true;
    }

    @Override
    public void single(long reference) {
        if (this.getId() != -1L) {
            this.reset();
        }
        if (this.pageCursor == null) {
            this.pageCursor = this.relationshipPage(reference);
        }
        this.next = reference;
        this.filterType = -1;
        this.highMark = -1L;
        this.nextStoreReference = -1L;
        this.open = true;
    }

    @Override
    public boolean next() {
        if (this.next == -1L) {
            this.reset();
            return false;
        }
        do {
            if (this.nextStoreReference == this.next) {
                this.relationshipAdvance(this, this.pageCursor);
                ++this.next;
                ++this.nextStoreReference;
            } else {
                this.relationship(this, this.next++, this.pageCursor);
                this.nextStoreReference = this.next;
            }
            if (this.next <= this.highMark) continue;
            if (this.isSingle()) {
                this.next = -1L;
                return this.inUse();
            }
            this.highMark = this.relationshipHighMark();
            if (this.next <= this.highMark) continue;
            this.next = -1L;
            return this.isWantedTypeAndInUse();
        } while (!this.isWantedTypeAndInUse());
        return true;
    }

    private boolean isWantedTypeAndInUse() {
        return (this.filterType == -1 || this.type() == this.filterType) && this.inUse();
    }

    @Override
    public void close() {
        if (this.open) {
            this.open = false;
            this.reset();
        }
    }

    private void reset() {
        this.next = -1L;
        this.setId(-1L);
    }

    @Override
    public String toString() {
        if (!this.open) {
            return "RelationshipScanCursor[closed state]";
        }
        return "RelationshipScanCursor[id=" + this.getId() + ", open state with: highMark=" + this.highMark + ", next=" + this.next + ", type=" + this.filterType + ", underlying record=" + super.toString() + "]";
    }

    private boolean isSingle() {
        return this.highMark == -1L;
    }

    @Override
    public void release() {
        if (this.pageCursor != null) {
            this.pageCursor.close();
            this.pageCursor = null;
        }
    }

    private void relationshipAdvance(RelationshipRecord record, PageCursor pageCursor) {
        this.relationshipStore.nextRecordByCursor(record, RecordLoad.CHECK, pageCursor);
    }
}

