/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexAccessor;
import org.neo4j.kernel.impl.index.schema.SpatialIndexCache;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;

public class SpatialIndexUpdater
extends SpatialIndexCache<NativeIndexUpdater<?, NativeIndexValue>>
implements IndexUpdater {
    SpatialIndexUpdater(SpatialIndexAccessor accessor, IndexUpdateMode mode) {
        super(new PartFactory(accessor, mode));
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
        IndexUpdater to = (IndexUpdater)this.select(((PointValue)update.values()[0]).getCoordinateReferenceSystem());
        switch (update.updateMode()) {
            case ADDED: 
            case REMOVED: {
                to.process(update);
                break;
            }
            case CHANGED: {
                IndexUpdater from = (IndexUpdater)this.select(((PointValue)update.beforeValues()[0]).getCoordinateReferenceSystem());
                if (from == to) {
                    from.process(update);
                    break;
                }
                from.process(IndexEntryUpdate.remove(update.getEntityId(), update.indexKey(), update.beforeValues()));
                to.process(IndexEntryUpdate.add(update.getEntityId(), update.indexKey(), update.values()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    @Override
    public void close() throws IOException {
        FusionIndexBase.forAll(NativeIndexUpdater::close, this);
    }

    static class PartFactory
    implements SpatialIndexCache.Factory<NativeIndexUpdater<?, NativeIndexValue>> {
        private final SpatialIndexAccessor accessor;
        private final IndexUpdateMode mode;

        PartFactory(SpatialIndexAccessor accessor, IndexUpdateMode mode) {
            this.accessor = accessor;
            this.mode = mode;
        }

        @Override
        public NativeIndexUpdater<?, NativeIndexValue> newSpatial(CoordinateReferenceSystem crs) throws IOException {
            return ((SpatialIndexAccessor.PartAccessor)this.accessor.select(crs)).newUpdater(this.mode);
        }
    }
}

