/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntIntHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ReadOnlyDbException;
import org.neo4j.kernel.impl.core.InMemoryTokenCache;
import org.neo4j.kernel.impl.core.NonUniqueTokenException;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;

public class DelegatingTokenHolder
implements TokenHolder {
    public static final String TYPE_PROPERTY_KEY = "PropertyKey";
    public static final String TYPE_RELATIONSHIP_TYPE = "RelationshipType";
    public static final String TYPE_LABEL = "Label";
    protected InMemoryTokenCache tokenCache;
    private final TokenCreator tokenCreator;

    public DelegatingTokenHolder(TokenCreator tokenCreator, String tokenType) {
        this.tokenCreator = tokenCreator;
        this.tokenCache = new InMemoryTokenCache(tokenType);
    }

    @Override
    public void setInitialTokens(List<NamedToken> tokens) throws NonUniqueTokenException {
        this.tokenCache.clear();
        this.tokenCache.putAll(tokens);
    }

    @Override
    public void addToken(NamedToken token) throws NonUniqueTokenException {
        this.tokenCache.put(token);
    }

    @Override
    public int getOrCreateId(String name) {
        Integer id = this.tokenCache.getId(name);
        if (id != null) {
            return id;
        }
        try {
            id = this.createToken(name);
            return id;
        }
        catch (ReadOnlyDbException e) {
            throw new TransactionFailureException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (Throwable e) {
            throw new TransactionFailureException("Could not create token.", e);
        }
    }

    private synchronized int createToken(String name) throws KernelException {
        Integer id = this.tokenCache.getId(name);
        if (id != null) {
            return id;
        }
        id = this.tokenCreator.createToken(name);
        try {
            this.tokenCache.put(new NamedToken(name, id.intValue()));
        }
        catch (NonUniqueTokenException e) {
            throw new IllegalStateException("Newly created token should be unique.", e);
        }
        return id;
    }

    @Override
    public void getOrCreateIds(String[] names, int[] ids) {
        if (names.length != ids.length) {
            throw new IllegalArgumentException("Name and id arrays must have the same length.");
        }
        boolean hasUnresolvedTokens = this.resolveIds(names, ids, Predicates.ALWAYS_TRUE_INT);
        if (hasUnresolvedTokens) {
            this.createMissingTokens(names, ids);
        }
    }

    private boolean resolveIds(String[] names, int[] ids, IntPredicate unresolvedIndexCheck) {
        boolean foundUnresolvable = false;
        for (int i = 0; i < ids.length; ++i) {
            Integer id = this.tokenCache.getId(names[i]);
            if (id != null) {
                ids[i] = id;
                continue;
            }
            foundUnresolvable = true;
            if (unresolvedIndexCheck.test(i)) break;
        }
        return foundUnresolvable;
    }

    private synchronized void createMissingTokens(String[] names, int[] ids) {
        IntHashSet unresolvedIndexes = new IntHashSet();
        this.resolveIds(names, ids, arg_0 -> DelegatingTokenHolder.lambda$createMissingTokens$0((MutableIntSet)unresolvedIndexes, arg_0));
        if (!unresolvedIndexes.isEmpty()) {
            ObjectIntHashMap<String> createdTokens = this.createUnresolvedTokens((IntSet)unresolvedIndexes, names, ids);
            ArrayList<NamedToken> createdTokensList = new ArrayList<NamedToken>(createdTokens.size());
            createdTokens.forEachKeyValue((ObjectIntProcedure & Serializable)(name, index) -> createdTokensList.add(new NamedToken(name, ids[index])));
            this.tokenCache.putAll(createdTokensList);
        }
    }

    private ObjectIntHashMap<String> createUnresolvedTokens(IntSet unresolvedIndexes, String[] names, int[] ids) {
        try {
            ObjectIntHashMap createdTokens = new ObjectIntHashMap();
            IntIntHashMap remappingIndexes = new IntIntHashMap();
            IntPredicate tokenCreateFilter = index -> {
                String name;
                int creatingIndex;
                boolean needsCreate = unresolvedIndexes.contains(index);
                if (needsCreate && (creatingIndex = createdTokens.getIfAbsentPut((Object)(name = names[index]), index)) != index) {
                    remappingIndexes.put(index, creatingIndex);
                    needsCreate = false;
                }
                return needsCreate;
            };
            this.tokenCreator.createTokens(names, ids, tokenCreateFilter);
            if (remappingIndexes.notEmpty()) {
                remappingIndexes.forEachKeyValue((IntIntProcedure & Serializable)(index, creatingIndex) -> {
                    ids[index] = ids[creatingIndex];
                });
            }
            return createdTokens;
        }
        catch (ReadOnlyDbException e) {
            throw new TransactionFailureException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (Throwable e) {
            throw new TransactionFailureException("Could not create tokens.", e);
        }
    }

    @Override
    public NamedToken getTokenById(int id) throws TokenNotFoundException {
        NamedToken result = this.getTokenByIdOrNull(id);
        if (result == null) {
            throw new TokenNotFoundException("Token for id " + id);
        }
        return result;
    }

    @Override
    public NamedToken getTokenByIdOrNull(int id) {
        return this.tokenCache.getToken(id);
    }

    @Override
    public int getIdByName(String name) {
        Integer id = this.tokenCache.getId(name);
        if (id == null) {
            return -1;
        }
        return id;
    }

    @Override
    public boolean getIdsByNames(String[] names, int[] ids) {
        return this.resolveIds(names, ids, Predicates.ALWAYS_FALSE_INT);
    }

    @Override
    public Iterable<NamedToken> getAllTokens() {
        return this.tokenCache.allTokens();
    }

    @Override
    public int size() {
        return this.tokenCache.size();
    }

    private static /* synthetic */ boolean lambda$createMissingTokens$0(MutableIntSet unresolvedIndexes, int i) {
        return !unresolvedIndexes.add(i);
    }
}

