/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Map;
import java.util.StringJoiner;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.StoreIndexDescriptor;
import org.neo4j.logging.Log;

public class LoggingMonitor
implements IndexProvider.Monitor {
    private final Log log;

    public LoggingMonitor(Log log) {
        this.log = log;
    }

    @Override
    public void failedToOpenIndex(StoreIndexDescriptor descriptor, String action, Exception cause) {
        this.log.error("Failed to open index:" + descriptor.getId() + ". " + action, (Throwable)cause);
    }

    @Override
    public void recoveryCompleted(IndexDescriptor schemaIndexDescriptor, String indexFile, Map<String, Object> data) {
        StringJoiner joiner = new StringJoiner(", ", "Schema index recovery completed: ", "");
        joiner.add("descriptor=" + schemaIndexDescriptor);
        joiner.add("file=" + indexFile);
        data.forEach((key, value) -> joiner.add(String.format("%s=%s", key, value)));
        this.log.info(joiner.toString());
    }
}

