/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.StoreIdIterator;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public abstract class NodeStoreScan<FAILURE extends Exception>
implements StoreScan<FAILURE> {
    private volatile boolean continueScanning;
    private final NodeRecord record;
    protected final NodeStore nodeStore;
    protected final LockService locks;
    private final long totalCount;
    private long count;

    public abstract void process(NodeRecord var1) throws FAILURE;

    public NodeStoreScan(NodeStore nodeStore, LockService locks, long totalCount) {
        this.nodeStore = nodeStore;
        this.record = (NodeRecord)nodeStore.newRecord();
        this.locks = locks;
        this.totalCount = totalCount;
    }

    @Override
    public void run() throws FAILURE {
        try (PrimitiveLongResourceIterator nodeIds = this.getNodeIdIterator();){
            this.continueScanning = true;
            while (this.continueScanning && nodeIds.hasNext()) {
                long id = nodeIds.next();
                Lock ignored = this.locks.acquireNodeLock(id, LockService.LockType.READ_LOCK);
                Throwable throwable = null;
                try {
                    ++this.count;
                    if (!this.nodeStore.getRecord(id, this.record, RecordLoad.FORCE).inUse()) continue;
                    this.process(this.record);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
        }
    }

    protected PrimitiveLongResourceIterator getNodeIdIterator() {
        return PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)new StoreIdIterator(this.nodeStore), null);
    }

    @Override
    public void stop() {
        this.continueScanning = false;
    }

    @Override
    public PopulationProgress getProgress() {
        if (this.totalCount > 0L) {
            return new PopulationProgress(this.count, this.totalCount);
        }
        return PopulationProgress.DONE;
    }
}

