/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public enum RecordLoad {
    NORMAL,
    CHECK,
    FORCE;


    public final boolean shouldLoad(boolean inUse) {
        return this == FORCE | inUse;
    }

    public final boolean verify(AbstractBaseRecord record) {
        boolean inUse;
        if (this == NORMAL & !(inUse = record.inUse())) {
            throw new InvalidRecordException(record + " not in use");
        }
        return this == FORCE | inUse;
    }

    public final void clearOrThrowCursorError(PageCursor cursor) {
        if (this == NORMAL) {
            try {
                cursor.checkAndClearCursorException();
            }
            catch (CursorException e) {
                throw new InvalidRecordException(e);
            }
        } else {
            cursor.clearCursorException();
        }
    }

    public boolean checkForOutOfBounds(PageCursor cursor) {
        return cursor.checkAndClearBoundsFlag() & this == NORMAL;
    }
}

