/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.kernel.builtinprocs.SchemaInfoResult;
import org.neo4j.kernel.builtinprocs.SortedLabels;
import org.neo4j.values.storable.Value;

public class SchemaCalculator {
    private Map<SortedLabels, Set<Integer>> labelSetToPropertyKeysMapping;
    private Map<Pair<SortedLabels, Integer>, ValueTypeListHelper> labelSetANDNodePropertyKeyIdToValueTypeMapping;
    private Set<SortedLabels> nullableLabelSets;
    private Map<Integer, String> labelIdToLabelNameMapping;
    private Map<Integer, String> propertyIdToPropertylNameMapping;
    private Map<Integer, String> relationshipTypIdToRelationshipNameMapping;
    private Map<Integer, Set<Integer>> relationshipTypeIdToPropertyKeysMapping;
    private Map<Pair<Integer, Integer>, ValueTypeListHelper> relationshipTypeIdANDPropertyTypeIdToValueTypeMapping;
    private Set<Integer> nullableRelationshipTypes;
    private final Set<Integer> emptyPropertyIdSet = Collections.unmodifiableSet(Collections.emptySet());
    private static final String NODE = "Node";
    private static final String RELATIONSHIP = "Relationship";
    private final Read dataRead;
    private final TokenRead tokenRead;
    private final CursorFactory cursors;

    SchemaCalculator(Transaction ktx) {
        this.dataRead = ktx.dataRead();
        this.tokenRead = ktx.tokenRead();
        this.cursors = ktx.cursors();
        int labelCount = this.tokenRead.labelCount();
        int relationshipTypeCount = this.tokenRead.relationshipTypeCount();
        this.labelSetToPropertyKeysMapping = new HashMap<SortedLabels, Set<Integer>>(labelCount);
        this.labelIdToLabelNameMapping = new HashMap<Integer, String>(labelCount);
        this.propertyIdToPropertylNameMapping = new HashMap<Integer, String>(this.tokenRead.propertyKeyCount());
        this.relationshipTypIdToRelationshipNameMapping = new HashMap<Integer, String>(relationshipTypeCount);
        this.relationshipTypeIdToPropertyKeysMapping = new HashMap<Integer, Set<Integer>>(relationshipTypeCount);
        this.labelSetANDNodePropertyKeyIdToValueTypeMapping = new HashMap<Pair<SortedLabels, Integer>, ValueTypeListHelper>();
        this.relationshipTypeIdANDPropertyTypeIdToValueTypeMapping = new HashMap<Pair<Integer, Integer>, ValueTypeListHelper>();
        this.nullableLabelSets = new HashSet<SortedLabels>();
        this.nullableRelationshipTypes = new HashSet<Integer>();
    }

    public Stream<SchemaInfoResult> calculateTabularResultStream() {
        this.calculateSchema();
        ArrayList<SchemaInfoResult> results = new ArrayList<SchemaInfoResult>();
        results.addAll(this.produceResultsForNodes());
        results.addAll(this.produceResultsForRelationships());
        return results.stream();
    }

    private List<SchemaInfoResult> produceResultsForRelationships() {
        ArrayList<SchemaInfoResult> results = new ArrayList<SchemaInfoResult>();
        for (Integer typeId : this.relationshipTypeIdToPropertyKeysMapping.keySet()) {
            String name = this.relationshipTypIdToRelationshipNameMapping.get(typeId);
            Set<Integer> propertyIds = this.relationshipTypeIdToPropertyKeysMapping.get(typeId);
            if (propertyIds.size() == 0) {
                results.add(new SchemaInfoResult(RELATIONSHIP, Collections.singletonList(name), null, null, true));
                continue;
            }
            propertyIds.forEach(propId -> {
                String propName = this.propertyIdToPropertylNameMapping.get(propId);
                ValueTypeListHelper valueTypeListHelper = this.relationshipTypeIdANDPropertyTypeIdToValueTypeMapping.get(Pair.of((Object)typeId, (Object)propId));
                if (this.nullableRelationshipTypes.contains(typeId)) {
                    results.add(new SchemaInfoResult(RELATIONSHIP, Collections.singletonList(name), propName, valueTypeListHelper.getCypherTypesList(), true));
                } else {
                    results.add(new SchemaInfoResult(RELATIONSHIP, Collections.singletonList(name), propName, valueTypeListHelper.getCypherTypesList(), valueTypeListHelper.isNullable()));
                }
            });
        }
        return results;
    }

    private List<SchemaInfoResult> produceResultsForNodes() {
        ArrayList<SchemaInfoResult> results = new ArrayList<SchemaInfoResult>();
        for (SortedLabels labelSet : this.labelSetToPropertyKeysMapping.keySet()) {
            ArrayList<String> labelNames = new ArrayList<String>();
            for (int i = 0; i < labelSet.numberOfLabels(); ++i) {
                String name = this.labelIdToLabelNameMapping.get(labelSet.label(i));
                labelNames.add(name);
            }
            Set<Integer> propertyIds = this.labelSetToPropertyKeysMapping.get(labelSet);
            if (propertyIds.size() == 0) {
                results.add(new SchemaInfoResult(NODE, labelNames, null, null, true));
                continue;
            }
            propertyIds.forEach(propId -> {
                String propName = this.propertyIdToPropertylNameMapping.get(propId);
                ValueTypeListHelper valueTypeListHelper = this.labelSetANDNodePropertyKeyIdToValueTypeMapping.get(Pair.of((Object)labelSet, (Object)propId));
                if (this.nullableLabelSets.contains(labelSet)) {
                    results.add(new SchemaInfoResult(NODE, labelNames, propName, valueTypeListHelper.getCypherTypesList(), true));
                } else {
                    results.add(new SchemaInfoResult(NODE, labelNames, propName, valueTypeListHelper.getCypherTypesList(), valueTypeListHelper.isNullable()));
                }
            });
        }
        return results;
    }

    private void calculateSchema() {
        this.scanEverythingBelongingToNodes();
        this.scanEverythingBelongingToRelationships();
        this.addNamesToCollection(this.tokenRead.labelsGetAllTokens(), this.labelIdToLabelNameMapping);
        this.addNamesToCollection(this.tokenRead.propertyKeyGetAllTokens(), this.propertyIdToPropertylNameMapping);
        this.addNamesToCollection(this.tokenRead.relationshipTypesGetAllTokens(), this.relationshipTypIdToRelationshipNameMapping);
    }

    private void scanEverythingBelongingToRelationships() {
        try (RelationshipScanCursor relationshipScanCursor = this.cursors.allocateRelationshipScanCursor();
             PropertyCursor propertyCursor = this.cursors.allocatePropertyCursor();){
            this.dataRead.allRelationshipsScan(relationshipScanCursor);
            while (relationshipScanCursor.next()) {
                int typeId = relationshipScanCursor.type();
                relationshipScanCursor.properties(propertyCursor);
                HashSet<Integer> propertyIds = new HashSet<Integer>();
                while (propertyCursor.next()) {
                    int propertyKey = propertyCursor.propertyKey();
                    Value currentValue = propertyCursor.propertyValue();
                    Pair key = Pair.of((Object)typeId, (Object)propertyKey);
                    this.updateValueTypeInMapping(currentValue, key, this.relationshipTypeIdANDPropertyTypeIdToValueTypeMapping);
                    propertyIds.add(propertyKey);
                }
                propertyCursor.close();
                Set<Integer> oldPropertyKeySet = this.relationshipTypeIdToPropertyKeysMapping.getOrDefault(typeId, this.emptyPropertyIdSet);
                if (oldPropertyKeySet == this.emptyPropertyIdSet) {
                    if (propertyIds.size() == 0) {
                        this.nullableRelationshipTypes.add(typeId);
                    }
                } else {
                    oldPropertyKeySet.removeAll(propertyIds);
                    oldPropertyKeySet.forEach(id -> {
                        Pair key = Pair.of((Object)typeId, (Object)id);
                        this.relationshipTypeIdANDPropertyTypeIdToValueTypeMapping.get(key).setNullable();
                    });
                }
                propertyIds.addAll(oldPropertyKeySet);
                this.relationshipTypeIdToPropertyKeysMapping.put(typeId, propertyIds);
            }
            relationshipScanCursor.close();
        }
    }

    private void scanEverythingBelongingToNodes() {
        try (NodeCursor nodeCursor = this.cursors.allocateNodeCursor();
             PropertyCursor propertyCursor = this.cursors.allocatePropertyCursor();){
            this.dataRead.allNodesScan(nodeCursor);
            while (nodeCursor.next()) {
                SortedLabels labels = SortedLabels.from(nodeCursor.labels());
                nodeCursor.properties(propertyCursor);
                HashSet<Integer> propertyIds = new HashSet<Integer>();
                while (propertyCursor.next()) {
                    Value currentValue = propertyCursor.propertyValue();
                    int propertyKeyId = propertyCursor.propertyKey();
                    Pair key = Pair.of((Object)labels, (Object)propertyKeyId);
                    this.updateValueTypeInMapping(currentValue, key, this.labelSetANDNodePropertyKeyIdToValueTypeMapping);
                    propertyIds.add(propertyKeyId);
                }
                propertyCursor.close();
                Set<Integer> oldPropertyKeySet = this.labelSetToPropertyKeysMapping.getOrDefault(labels, this.emptyPropertyIdSet);
                if (oldPropertyKeySet == this.emptyPropertyIdSet) {
                    if (propertyIds.size() == 0) {
                        this.nullableLabelSets.add(labels);
                    }
                } else {
                    oldPropertyKeySet.removeAll(propertyIds);
                    oldPropertyKeySet.forEach(id -> {
                        Pair key = Pair.of((Object)labels, (Object)id);
                        this.labelSetANDNodePropertyKeyIdToValueTypeMapping.get(key).setNullable();
                    });
                }
                propertyIds.addAll(oldPropertyKeySet);
                this.labelSetToPropertyKeysMapping.put(labels, propertyIds);
            }
            nodeCursor.close();
        }
    }

    private <X, Y> void updateValueTypeInMapping(Value currentValue, Pair<X, Y> key, Map<Pair<X, Y>, ValueTypeListHelper> mappingToUpdate) {
        ValueTypeListHelper helper = mappingToUpdate.get(key);
        if (helper == null) {
            helper = new ValueTypeListHelper(currentValue);
            mappingToUpdate.put(key, helper);
        } else {
            helper.updateValueTypesWith(currentValue);
        }
    }

    private void addNamesToCollection(Iterator<NamedToken> labelIterator, Map<Integer, String> collection) {
        while (labelIterator.hasNext()) {
            NamedToken label = labelIterator.next();
            collection.put(label.id(), label.name());
        }
    }

    private class ValueTypeListHelper {
        private Set<String> seenValueTypes = new HashSet<String>();
        private boolean isNullable;

        ValueTypeListHelper(Value v) {
            this.updateValueTypesWith(v);
        }

        private void setNullable() {
            this.isNullable = true;
        }

        public boolean isNullable() {
            return this.isNullable;
        }

        List<String> getCypherTypesList() {
            return new ArrayList<String>(this.seenValueTypes);
        }

        void updateValueTypesWith(Value newValue) {
            if (newValue == null) {
                throw new IllegalArgumentException();
            }
            this.seenValueTypes.add(newValue.getTypeName());
        }
    }
}

