/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexLimitation;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.StringLayout;
import org.neo4j.kernel.impl.index.schema.StringSchemaIndexAccessor;
import org.neo4j.kernel.impl.index.schema.StringSchemaIndexPopulator;
import org.neo4j.kernel.impl.index.schema.StringSchemaKey;
import org.neo4j.values.storable.ValueCategory;

public class StringIndexProvider
extends NativeIndexProvider<StringSchemaKey, NativeSchemaValue> {
    public static final String KEY = "string";
    static final IndexCapability CAPABILITY = new StringIndexCapability();
    private static final IndexProvider.Descriptor STRING_PROVIDER_DESCRIPTOR = new IndexProvider.Descriptor("string", "1.0");

    public StringIndexProvider(PageCache pageCache, FileSystemAbstraction fs, IndexDirectoryStructure.Factory directoryStructure, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(STRING_PROVIDER_DESCRIPTOR, 0, directoryStructure, pageCache, fs, monitor, recoveryCleanupWorkCollector, readOnly);
    }

    @Override
    Layout<StringSchemaKey, NativeSchemaValue> layout(SchemaIndexDescriptor descriptor) {
        return new StringLayout();
    }

    @Override
    protected IndexPopulator newIndexPopulator(File storeFile, Layout<StringSchemaKey, NativeSchemaValue> layout, SchemaIndexDescriptor descriptor, long indexId, IndexSamplingConfig samplingConfig) {
        return new StringSchemaIndexPopulator(this.pageCache, this.fs, storeFile, layout, this.monitor, descriptor, indexId, samplingConfig);
    }

    @Override
    protected IndexAccessor newIndexAccessor(File storeFile, Layout<StringSchemaKey, NativeSchemaValue> layout, SchemaIndexDescriptor descriptor, long indexId, IndexSamplingConfig samplingConfig) throws IOException {
        return new StringSchemaIndexAccessor(this.pageCache, this.fs, storeFile, layout, this.recoveryCleanupWorkCollector, this.monitor, descriptor, indexId, samplingConfig);
    }

    @Override
    public IndexCapability getCapability(SchemaIndexDescriptor schemaIndexDescriptor) {
        return CAPABILITY;
    }

    private static class StringIndexCapability
    implements IndexCapability {
        private final IndexLimitation[] limitations = new IndexLimitation[]{IndexLimitation.SLOW_CONTAINS};

        private StringIndexCapability() {
        }

        public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
            if (this.support(valueCategories)) {
                return ORDER_ASC;
            }
            return ORDER_NONE;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            if (this.support(valueCategories)) {
                return IndexValueCapability.YES;
            }
            if (this.singleWildcard(valueCategories)) {
                return IndexValueCapability.PARTIAL;
            }
            return IndexValueCapability.NO;
        }

        public IndexLimitation[] limitations() {
            return this.limitations;
        }

        private boolean support(ValueCategory[] valueCategories) {
            return valueCategories.length == 1 && valueCategories[0] == ValueCategory.TEXT;
        }
    }
}

