/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.test.Race;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.impl.batchimport.DataStatistics;

public class DataStatisticsTest {
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldSumCounts() throws Throwable {
        DataStatistics stats = new DataStatistics(1L, 2L, new DataStatistics.RelationshipTypeCount[0]);
        Race race = new Race();
        int types = 10;
        long[] expected = new long[types];
        int threads = Runtime.getRuntime().availableProcessors();
        for (int i = 0; i < threads; ++i) {
            long[] local = new long[types];
            for (int j = 0; j < types; ++j) {
                local[j] = this.random.nextInt(1000, 2000);
                int n = j;
                expected[n] = expected[n] + local[j];
            }
            race.addContestant(() -> {
                try (DataStatistics.Client client = stats.newClient();){
                    int typeId = 0;
                    while (typeId < types) {
                        while (true) {
                            int n = typeId++;
                            long l = local[n];
                            local[n] = l - 1L;
                            if (l <= 0L) break;
                            client.increment(typeId);
                        }
                    }
                }
            });
        }
        race.go();
        stats.forEach(count -> Assert.assertEquals((long)expected[count.getTypeId()], (long)count.getCount()));
    }

    @Test
    public void shouldGrowArrayProperly() {
        DataStatistics stats = new DataStatistics(1L, 1L, new DataStatistics.RelationshipTypeCount[0]);
        int typeId = 1000;
        try (DataStatistics.Client client = stats.newClient();){
            client.increment(typeId);
        }
        DataStatistics.RelationshipTypeCount count = this.typeCount(stats.iterator(), typeId);
        Assert.assertEquals((long)1L, (long)count.getCount());
        Assert.assertEquals((long)typeId, (long)count.getTypeId());
    }

    private DataStatistics.RelationshipTypeCount typeCount(Iterator<DataStatistics.RelationshipTypeCount> iterator, int typeId) {
        while (iterator.hasNext()) {
            DataStatistics.RelationshipTypeCount count = iterator.next();
            if (count.getTypeId() != typeId) continue;
            return count;
        }
        throw new IllegalStateException("Couldn't find " + typeId);
    }
}

