/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.schema;

import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.storageengine.api.schema.AbstractIndexReader;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.storageengine.api.schema.SimpleNodeValueClient;
import org.neo4j.values.storable.Value;

public class DefaultIndexReaderTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void defaultQueryImplementationMustThrowForUnsupportedIndexOrder() throws Exception {
        IndexReader indexReader = this.stubIndexReader();
        this.expectedException.expect(UnsupportedOperationException.class);
        String expectedMessage = String.format("This reader only have support for index order %s. Provided index order was %s.", IndexOrder.NONE, IndexOrder.ASCENDING);
        this.expectedException.expectMessage(Matchers.containsString((String)expectedMessage));
        indexReader.query((IndexProgressor.NodeValueClient)new SimpleNodeValueClient(), IndexOrder.ASCENDING, new IndexQuery[]{IndexQuery.exists((int)1)});
    }

    private IndexReader stubIndexReader() {
        return new AbstractIndexReader(null){

            public long countIndexedNodes(long nodeId, Value ... propertyValues) {
                return 0L;
            }

            public IndexSampler createSampler() {
                return null;
            }

            public PrimitiveLongResourceIterator query(IndexQuery ... predicates) {
                return null;
            }

            public boolean hasFullValuePrecision(IndexQuery ... predicates) {
                return false;
            }

            public void close() {
            }
        };
    }
}

