/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.VersionedHashMap;

public class VersionedHashMapTest {
    @Test
    public void shouldGetAndContain() {
        VersionedHashMap map = new VersionedHashMap();
        map.put((Object)22, (Object)true);
        Assert.assertThat((Object)map.containsKey((Object)22), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)map.containsKey((Object)21), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)map.containsKey((Object)23), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)map.get((Object)22), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)map.containsValue((Object)true), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)map.containsValue((Object)false), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldReplace() {
        VersionedHashMap map = new VersionedHashMap();
        map.put((Object)22, (Object)true);
        map.put((Object)22, (Object)false);
        Assert.assertThat((Object)map.containsKey((Object)22), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)map.containsKey((Object)21), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)map.containsKey((Object)23), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)map.get((Object)22), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)map.containsValue((Object)false), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)map.containsValue((Object)true), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldRemove() {
        VersionedHashMap map = new VersionedHashMap();
        map.put((Object)22, (Object)true);
        map.remove((Object)22);
        Assert.assertThat((Object)map.containsKey((Object)22), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)map.containsKey((Object)21), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)map.containsKey((Object)23), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)map.get((Object)22), (Matcher)Matchers.equalTo(null));
        Assert.assertThat((Object)map.containsValue((Object)false), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)map.containsValue((Object)true), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldNotSeeAdditionsWhileIterating() {
        VersionedHashMap map = new VersionedHashMap();
        for (int i = 0; i < 10; ++i) {
            map.put((Object)(16 + i), (Object)true);
        }
        boolean added = false;
        int count = 0;
        for (Object k : map.keySet()) {
            if (!added) {
                added = true;
                for (int i = 0; i < 10; ++i) {
                    map.put((Object)i, (Object)true);
                }
            }
            ++count;
        }
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)10));
        Assert.assertThat((Object)map.size(), (Matcher)Matchers.equalTo((Object)20));
    }

    @Test
    public void shouldSeeRemovalsWhileIterating() {
        VersionedHashMap map = new VersionedHashMap();
        for (int i = 0; i < 10; ++i) {
            map.put((Object)i, (Object)true);
        }
        int count = 0;
        for (Object k : map.keySet()) {
            for (Object o : map.keySet()) {
                map.remove(o);
            }
            ++count;
        }
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)map.size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void shouldAllowRemovalsWhileIterating() {
        VersionedHashMap map = new VersionedHashMap();
        for (int i = 0; i < 10; ++i) {
            map.put((Object)i, (Object)true);
        }
        int count = 0;
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
            ++count;
        }
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)10));
        Assert.assertThat((Object)map.size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void shouldHandleResizing() {
        VersionedHashMap map = new VersionedHashMap(16, 0.5f);
        for (int i = 0; i < 128; ++i) {
            map.put((Object)i, (Object)i);
        }
        Assert.assertThat((Object)map.size(), (Matcher)Matchers.equalTo((Object)128));
        int count = 0;
        for (int i = 0; i < 128; ++i) {
            Assert.assertThat((Object)map.get((Object)i), (Matcher)Matchers.equalTo((Object)i));
            ++count;
        }
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)128));
    }

    @Test
    public void shouldAllowRemovalsWhileIteratingEvenInFaceOfResizing() {
        VersionedHashMap map = new VersionedHashMap(16, 5.0f);
        for (int i = 0; i < 128; ++i) {
            map.put((Object)i, (Object)true);
        }
        int count = 0;
        for (Object k : map.keySet()) {
            int i;
            for (i = 128; i < 256; ++i) {
                map.put((Object)i, (Object)true);
            }
            for (i = 0; i < 128; ++i) {
                map.remove((Object)i);
            }
            ++count;
        }
        Assert.assertThat((Object)count, (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)map.size(), (Matcher)Matchers.equalTo((Object)128));
    }
}

