/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Closeable;
import java.io.Flushable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.PositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.PositionableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.storageengine.api.ReadPastEndException;

public class InMemoryClosableChannel
implements ReadableClosablePositionAwareChannel,
FlushablePositionAwareChannel {
    private final byte[] bytes;
    private final Reader reader;
    private final Writer writer;
    private static final Flushable NO_OP_FLUSHABLE = () -> {};

    public InMemoryClosableChannel() {
        this(1000);
    }

    public InMemoryClosableChannel(byte[] bytes, boolean append) {
        this.bytes = bytes;
        ByteBuffer writeBuffer = ByteBuffer.wrap(this.bytes);
        ByteBuffer readBuffer = ByteBuffer.wrap(this.bytes);
        if (append) {
            writeBuffer.position(bytes.length);
        }
        this.writer = new Writer(writeBuffer);
        this.reader = new Reader(readBuffer);
    }

    public InMemoryClosableChannel(int bufferSize) {
        this(new byte[bufferSize], false);
    }

    public void reset() {
        this.writer.clear();
        this.reader.clear();
        Arrays.fill(this.bytes, (byte)0);
    }

    public Reader reader() {
        return this.reader;
    }

    public Writer writer() {
        return this.writer;
    }

    public InMemoryClosableChannel put(byte b) {
        this.writer.put(b);
        return this;
    }

    public InMemoryClosableChannel putShort(short s) {
        this.writer.putShort(s);
        return this;
    }

    public InMemoryClosableChannel putInt(int i) {
        this.writer.putInt(i);
        return this;
    }

    public InMemoryClosableChannel putLong(long l) {
        this.writer.putLong(l);
        return this;
    }

    public InMemoryClosableChannel putFloat(float f) {
        this.writer.putFloat(f);
        return this;
    }

    public InMemoryClosableChannel putDouble(double d) {
        this.writer.putDouble(d);
        return this;
    }

    public InMemoryClosableChannel put(byte[] bytes, int length) {
        this.writer.put(bytes, length);
        return this;
    }

    public boolean isOpen() {
        return true;
    }

    public void close() {
        this.reader.close();
        this.writer.close();
    }

    public Flushable prepareForFlush() {
        return NO_OP_FLUSHABLE;
    }

    public byte get() throws ReadPastEndException {
        return this.reader.get();
    }

    public short getShort() throws ReadPastEndException {
        return this.reader.getShort();
    }

    public int getInt() throws ReadPastEndException {
        return this.reader.getInt();
    }

    public long getLong() throws ReadPastEndException {
        return this.reader.getLong();
    }

    public float getFloat() throws ReadPastEndException {
        return this.reader.getFloat();
    }

    public double getDouble() throws ReadPastEndException {
        return this.reader.getDouble();
    }

    public void get(byte[] bytes, int length) throws ReadPastEndException {
        this.reader.get(bytes, length);
    }

    public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) {
        return this.writer.getCurrentPosition(positionMarker);
    }

    public int positionWriter(int position) {
        int previous = this.writer.position();
        this.writer.position(position);
        return previous;
    }

    public int positionReader(int position) {
        int previous = this.reader.position();
        this.reader.position(position);
        return previous;
    }

    public int readerPosition() {
        return this.reader.position();
    }

    public int writerPosition() {
        return this.writer.position();
    }

    public void truncateTo(int offset) {
        this.reader.limit(offset);
    }

    public int capacity() {
        return this.bytes.length;
    }

    public int availableBytesToRead() {
        return this.reader.remaining();
    }

    public int availableBytesToWrite() {
        return this.writer.remaining();
    }

    public class Writer
    extends ByteBufferBase
    implements FlushablePositionAwareChannel {
        Writer(ByteBuffer buffer) {
            super(buffer);
        }

        public Writer put(byte b) {
            this.buffer.put(b);
            return this;
        }

        public Writer putShort(short s) {
            this.buffer.putShort(s);
            return this;
        }

        public Writer putInt(int i) {
            this.buffer.putInt(i);
            return this;
        }

        public Writer putLong(long l) {
            this.buffer.putLong(l);
            return this;
        }

        public Writer putFloat(float f) {
            this.buffer.putFloat(f);
            return this;
        }

        public Writer putDouble(double d) {
            this.buffer.putDouble(d);
            return this;
        }

        public Writer put(byte[] bytes, int length) {
            this.buffer.put(bytes, 0, length);
            return this;
        }

        public Flushable prepareForFlush() {
            return NO_OP_FLUSHABLE;
        }
    }

    public class Reader
    extends ByteBufferBase
    implements ReadableClosablePositionAwareChannel,
    PositionableChannel {
        Reader(ByteBuffer buffer) {
            super(buffer);
        }

        public byte get() throws ReadPastEndException {
            this.ensureAvailableToRead(1);
            return this.buffer.get();
        }

        public short getShort() throws ReadPastEndException {
            this.ensureAvailableToRead(2);
            return this.buffer.getShort();
        }

        public int getInt() throws ReadPastEndException {
            this.ensureAvailableToRead(4);
            return this.buffer.getInt();
        }

        public long getLong() throws ReadPastEndException {
            this.ensureAvailableToRead(8);
            return this.buffer.getLong();
        }

        public float getFloat() throws ReadPastEndException {
            this.ensureAvailableToRead(4);
            return this.buffer.getFloat();
        }

        public double getDouble() throws ReadPastEndException {
            this.ensureAvailableToRead(8);
            return this.buffer.getDouble();
        }

        public void get(byte[] bytes, int length) throws ReadPastEndException {
            this.ensureAvailableToRead(length);
            this.buffer.get(bytes, 0, length);
        }

        private void ensureAvailableToRead(int i) throws ReadPastEndException {
            if (this.remaining() < i || this.position() + i > InMemoryClosableChannel.this.writer.position()) {
                throw ReadPastEndException.INSTANCE;
            }
        }

        public void setCurrentPosition(long byteOffset) {
            this.buffer.position(Math.toIntExact(byteOffset));
        }
    }

    class ByteBufferBase
    implements PositionAwareChannel,
    Closeable {
        protected final ByteBuffer buffer;

        ByteBufferBase(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        void clear() {
            this.buffer.clear();
        }

        int position() {
            return this.buffer.position();
        }

        void position(int position) {
            this.buffer.position(position);
        }

        int remaining() {
            return this.buffer.remaining();
        }

        void limit(int offset) {
            this.buffer.limit(offset);
        }

        @Override
        public void close() {
        }

        public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) {
            positionMarker.mark(0L, (long)this.buffer.position());
            return positionMarker;
        }
    }
}

