/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;

public class BigEndianByteArrayBufferTest {
    BigEndianByteArrayBuffer buffer = new BigEndianByteArrayBuffer(new byte[8]);

    @Test
    public void shouldWriteLong() {
        this.buffer.putLong(0, -6066930334832433271L);
        Assert.assertEquals((long)171L, (long)(0xFF & this.buffer.getByte(0)));
        Assert.assertEquals((long)205L, (long)(0xFF & this.buffer.getByte(1)));
        Assert.assertEquals((long)239L, (long)(0xFF & this.buffer.getByte(2)));
        Assert.assertEquals((long)1L, (long)(0xFF & this.buffer.getByte(3)));
        Assert.assertEquals((long)35L, (long)(0xFF & this.buffer.getByte(4)));
        Assert.assertEquals((long)69L, (long)(0xFF & this.buffer.getByte(5)));
        Assert.assertEquals((long)103L, (long)(0xFF & this.buffer.getByte(6)));
        Assert.assertEquals((long)137L, (long)(0xFF & this.buffer.getByte(7)));
        Assert.assertEquals((long)-6066930334832433271L, (long)this.buffer.getLong(0));
    }

    @Test
    public void shouldWriteInt() {
        this.buffer.putInt(0, 305419896);
        this.buffer.putInt(4, -2023406815);
        Assert.assertEquals((long)305419896L, (long)this.buffer.getInt(0));
        Assert.assertEquals((long)-2023406815L, (long)this.buffer.getInt(4));
        Assert.assertEquals((long)1311768467139281697L, (long)this.buffer.getLong(0));
    }

    @Test
    public void shouldWriteShort() {
        this.buffer.putShort(0, (short)4660);
        this.buffer.putShort(2, (short)17185);
        this.buffer.putShort(4, (short)-21555);
        this.buffer.putShort(6, (short)-292);
        Assert.assertEquals((long)4660L, (long)this.buffer.getShort(0));
        Assert.assertEquals((long)17185L, (long)this.buffer.getShort(2));
        Assert.assertEquals((long)-21555L, (long)this.buffer.getShort(4));
        Assert.assertEquals((long)-292L, (long)this.buffer.getShort(6));
    }

    @Test
    public void shouldWriteChar() {
        this.buffer.putChar(0, 'H');
        this.buffer.putChar(2, 'E');
        this.buffer.putChar(4, 'L');
        this.buffer.putChar(6, 'O');
        Assert.assertEquals((long)72L, (long)this.buffer.getChar(0));
        Assert.assertEquals((long)69L, (long)this.buffer.getChar(2));
        Assert.assertEquals((long)76L, (long)this.buffer.getChar(4));
        Assert.assertEquals((long)79L, (long)this.buffer.getChar(6));
    }

    @Test
    public void shouldWriteByte() {
        int i;
        for (i = 0; i < this.buffer.size(); ++i) {
            this.buffer.putByte(i, (byte)((1 << i) + i));
        }
        for (i = 0; i < this.buffer.size(); ++i) {
            Assert.assertEquals((long)((byte)((1 << i) + i)), (long)this.buffer.getByte(i));
        }
    }

    @Test
    public void shouldCompareByteArrays() {
        Matcher LESS_THAN = Matchers.lessThan((Comparable)Integer.valueOf(0));
        Matcher GREATER_THAN = Matchers.greaterThan((Comparable)Integer.valueOf(0));
        Matcher EQUAL_TO = Matchers.equalTo((Object)0);
        BigEndianByteArrayBufferTest.assertCompare(new byte[0], (Matcher<Integer>)EQUAL_TO, new byte[0]);
        BigEndianByteArrayBufferTest.assertCompare(new byte[]{1, 2, 3}, (Matcher<Integer>)EQUAL_TO, new byte[]{1, 2, 3});
        BigEndianByteArrayBufferTest.assertCompare(new byte[]{1, 2, 3}, (Matcher<Integer>)LESS_THAN, new byte[]{1, 2, 4});
        BigEndianByteArrayBufferTest.assertCompare(new byte[]{1, 2, 3}, (Matcher<Integer>)LESS_THAN, new byte[]{2, 2, 3});
        BigEndianByteArrayBufferTest.assertCompare(new byte[]{1, 2, 3}, (Matcher<Integer>)GREATER_THAN, new byte[]{1, 2, 0});
        BigEndianByteArrayBufferTest.assertCompare(new byte[]{1, 2, 3}, (Matcher<Integer>)GREATER_THAN, new byte[]{0, 2, 3});
    }

    private static void assertCompare(byte[] lhs, Matcher<Integer> isAsExpected, byte[] rhs) {
        Assert.assertThat((Object)BigEndianByteArrayBuffer.compare((byte[])lhs, (byte[])rhs, (int)0), isAsExpected);
    }
}

