/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Random;

public abstract class TestStringCharset
extends Enum<TestStringCharset> {
    public static final /* enum */ TestStringCharset UNIFORM_ASCII;
    public static final /* enum */ TestStringCharset SYMBOLS;
    public static final /* enum */ TestStringCharset UNIFORM_LATIN;
    public static final /* enum */ TestStringCharset LONG;
    public static final /* enum */ TestStringCharset INT;
    public static final /* enum */ TestStringCharset UNICODE;
    static char[] SYMBOL_CHARS;
    private static Random random;
    private static final /* synthetic */ TestStringCharset[] $VALUES;

    public static TestStringCharset[] values() {
        return (TestStringCharset[])$VALUES.clone();
    }

    public static TestStringCharset valueOf(String name) {
        return Enum.valueOf(TestStringCharset.class, name);
    }

    abstract String randomString(int var1);

    static {
        int c;
        UNIFORM_ASCII = new TestStringCharset(){

            @Override
            String randomString(int maxLen) {
                char[] chars = new char[random.nextInt(maxLen + 1)];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = (char)(32 + random.nextInt(94));
                }
                return new String(chars);
            }
        };
        SYMBOLS = new TestStringCharset(){

            @Override
            String randomString(int maxLen) {
                char[] chars = new char[random.nextInt(maxLen + 1)];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = SYMBOL_CHARS[random.nextInt(SYMBOL_CHARS.length)];
                }
                return new String(chars);
            }
        };
        UNIFORM_LATIN = new TestStringCharset(){

            @Override
            String randomString(int maxLen) {
                char[] chars = new char[random.nextInt(maxLen + 1)];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = (char)(32 + random.nextInt(192));
                    if (chars[i] <= '\u007f') continue;
                    int n = i;
                    chars[n] = (char)(chars[n] + 32);
                }
                return new String(chars);
            }
        };
        LONG = new TestStringCharset(){

            @Override
            String randomString(int maxLen) {
                return Long.toString(random.nextLong() % (long)Math.pow(10.0, maxLen));
            }
        };
        INT = new TestStringCharset(){

            @Override
            String randomString(int maxLen) {
                return Long.toString(random.nextInt());
            }
        };
        UNICODE = new TestStringCharset(){

            @Override
            String randomString(int maxLen) {
                char[] chars = new char[random.nextInt(maxLen + 1)];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = (char)(1 + random.nextInt(55294));
                }
                return new String(chars);
            }
        };
        $VALUES = new TestStringCharset[]{UNIFORM_ASCII, SYMBOLS, UNIFORM_LATIN, LONG, INT, UNICODE};
        SYMBOL_CHARS = new char[63];
        TestStringCharset.SYMBOL_CHARS[0] = 95;
        int i = 1;
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            TestStringCharset.SYMBOL_CHARS[i++] = c;
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            TestStringCharset.SYMBOL_CHARS[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            TestStringCharset.SYMBOL_CHARS[i++] = c;
        }
        random = new Random();
    }
}

