/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Random;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexPopulationStressTest;
import org.neo4j.kernel.impl.index.schema.TemporalIndexProvider;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;

public class TemporalIndexPopulationStressTest
extends IndexPopulationStressTest {
    private static final ZoneId[] zoneIds = (ZoneId[])ZoneId.getAvailableZoneIds().stream().map(ZoneId::of).toArray(ZoneId[]::new);
    private static final int MAX_OFFSET = ZoneOffset.MAX.getTotalSeconds();
    private static final int MIN_OFFSET = ZoneOffset.MIN.getTotalSeconds();

    @Override
    IndexProvider newProvider(IndexDirectoryStructure.Factory directory) {
        return new TemporalIndexProvider(this.rules.pageCache(), this.rules.fileSystem(), directory, IndexProvider.Monitor.EMPTY, RecoveryCleanupWorkCollector.IMMEDIATE, false);
    }

    @Override
    Value randomValue(Random random) {
        switch (random.nextInt(6)) {
            case 0: {
                return DateValue.epochDate((long)random.nextInt(1000000));
            }
            case 1: {
                return LocalDateTimeValue.localDateTime((long)this.epochSecond(random), (long)this.nanosOfSecond(random));
            }
            case 2: {
                ZoneId zone = random.nextBoolean() ? this.randomZoneOffset(random) : this.randomZoneId(random);
                return DateTimeValue.datetime((long)this.epochSecond(random), (long)this.nanosOfSecond(random), (ZoneId)zone);
            }
            case 3: {
                return LocalTimeValue.localTime((long)this.secondsOfDay(random));
            }
            case 4: {
                return TimeValue.time((long)this.secondsOfDay(random), (ZoneOffset)this.randomZoneOffset(random));
            }
            case 5: {
                return DurationValue.duration((long)random.nextInt(1000000), (long)random.nextInt(1000), (long)random.nextInt(1000), (long)random.nextInt(1000));
            }
        }
        throw new IllegalStateException("Managed to break java.util.Random");
    }

    private int secondsOfDay(Random random) {
        return random.nextInt(1000000000);
    }

    private int epochSecond(Random random) {
        return random.nextInt(1000000000);
    }

    private ZoneOffset randomZoneOffset(Random random) {
        return ZoneOffset.ofTotalSeconds(random.nextInt(MAX_OFFSET - MIN_OFFSET) + MIN_OFFSET);
    }

    private ZoneId randomZoneId(Random random) {
        return zoneIds[random.nextInt(zoneIds.length)];
    }

    private long nanosOfSecond(Random random) {
        return random.nextInt(1000000000);
    }
}

