/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexPopulatorTest;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.storageengine.api.schema.IndexSample;

public abstract class NativeUniqueSchemaIndexPopulatorTest<KEY extends NativeSchemaKey<KEY>, VALUE extends NativeSchemaValue>
extends NativeSchemaIndexPopulatorTest<KEY, VALUE> {
    @Test
    public void addShouldThrowOnDuplicateValues() throws Exception {
        this.populator.create();
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdatesWithDuplicateValues();
        try {
            this.populator.add(Arrays.asList(updates));
            Assert.fail((String)"Updates should have conflicted");
        }
        catch (IndexEntryConflictException indexEntryConflictException) {
        }
        finally {
            this.populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updaterShouldThrowOnDuplicateValues() throws Exception {
        this.populator.create();
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdatesWithDuplicateValues();
        IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor);
        for (IndexEntryUpdate<SchemaIndexDescriptor> update : updates) {
            updater.process(update);
        }
        try {
            updater.close();
            Assert.fail((String)"Updates should have conflicted");
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)Exceptions.contains((Throwable)e, (Class[])new Class[]{IndexEntryConflictException.class}));
        }
        finally {
            this.populator.close(true);
        }
    }

    @Test
    public void shouldSampleUpdates() throws Exception {
        this.populator.create();
        IndexEntryUpdate<SchemaIndexDescriptor>[] updates = this.layoutUtil.someUpdates();
        this.populator.add(Arrays.asList(updates));
        for (IndexEntryUpdate<SchemaIndexDescriptor> update : updates) {
            this.populator.includeSample(update);
        }
        IndexSample sample = this.populator.sampleResult();
        Assert.assertEquals((long)updates.length, (long)sample.sampleSize());
        Assert.assertEquals((long)updates.length, (long)sample.uniqueValues());
        Assert.assertEquals((long)updates.length, (long)sample.indexSize());
        this.populator.close(true);
    }
}

