/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class LayoutTestUtil<KEY extends NativeSchemaKey<KEY>, VALUE extends NativeSchemaValue> {
    private static final Comparator<IndexEntryUpdate<SchemaIndexDescriptor>> UPDATE_COMPARATOR = (u1, u2) -> Values.COMPARATOR.compare(u1.values()[0], u2.values()[0]);
    final SchemaIndexDescriptor schemaIndexDescriptor;

    LayoutTestUtil(SchemaIndexDescriptor schemaIndexDescriptor) {
        this.schemaIndexDescriptor = schemaIndexDescriptor;
    }

    abstract Layout<KEY, VALUE> createLayout();

    abstract IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdates();

    protected double fractionDuplicates() {
        return 0.1;
    }

    abstract IndexQuery rangeQuery(Value var1, boolean var2, Value var3, boolean var4);

    abstract int compareIndexedPropertyValue(KEY var1, KEY var2);

    SchemaIndexDescriptor indexDescriptor() {
        return this.schemaIndexDescriptor;
    }

    void copyValue(VALUE value, VALUE intoValue) {
    }

    Iterator<IndexEntryUpdate<SchemaIndexDescriptor>> randomUpdateGenerator(final RandomRule random) {
        final double fractionDuplicates = this.fractionDuplicates();
        return new PrefetchingIterator<IndexEntryUpdate<SchemaIndexDescriptor>>(){
            private final Set<Object> uniqueCompareValues = new HashSet<Object>();
            private final List<Value> uniqueValues = new ArrayList<Value>();
            private long currentEntityId;

            protected IndexEntryUpdate<SchemaIndexDescriptor> fetchNextOrNull() {
                Value value = fractionDuplicates > 0.0 && !this.uniqueValues.isEmpty() && (double)random.nextFloat() < fractionDuplicates ? this.existingNonUniqueValue(random) : LayoutTestUtil.this.newUniqueValue(random, this.uniqueCompareValues, this.uniqueValues);
                return LayoutTestUtil.this.add(this.currentEntityId++, value);
            }

            private Value existingNonUniqueValue(RandomRule randomRule) {
                return this.uniqueValues.get(randomRule.nextInt(this.uniqueValues.size()));
            }
        };
    }

    abstract Value newUniqueValue(RandomRule var1, Set<Object> var2, List<Value> var3);

    Value[] extractValuesFromUpdates(IndexEntryUpdate<SchemaIndexDescriptor>[] updates) {
        Value[] values = new Value[updates.length];
        for (int i = 0; i < updates.length; ++i) {
            if (updates[i].values().length > 1) {
                throw new UnsupportedOperationException("This method does not support composite entries");
            }
            values[i] = updates[i].values()[0];
        }
        return values;
    }

    abstract IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesNoDuplicateValues();

    abstract IndexEntryUpdate<SchemaIndexDescriptor>[] someUpdatesWithDuplicateValues();

    IndexEntryUpdate<SchemaIndexDescriptor>[] generateAddUpdatesFor(Object[] values) {
        IndexEntryUpdate[] indexEntryUpdates = new IndexEntryUpdate[values.length];
        for (int i = 0; i < indexEntryUpdates.length; ++i) {
            indexEntryUpdates[i] = this.add(i, Values.of((Object)values[i]));
        }
        return indexEntryUpdates;
    }

    protected IndexEntryUpdate<SchemaIndexDescriptor> add(long nodeId, Value value) {
        return IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.schemaIndexDescriptor, (Value[])new Value[]{value});
    }

    static int countUniqueValues(IndexEntryUpdate<SchemaIndexDescriptor>[] updates) {
        return Stream.of(updates).map(update -> update.values()[0]).collect(Collectors.toSet()).size();
    }

    static int countUniqueValues(Object[] updates) {
        return Stream.of(updates).collect(Collectors.toSet()).size();
    }

    void sort(IndexEntryUpdate<SchemaIndexDescriptor>[] updates) {
        Arrays.sort(updates, UPDATE_COMPARATOR);
    }
}

