/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.Callable;
import java.util.function.IntPredicate;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.index.FlipFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexMeta;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.schema.IndexSample;

@RunWith(value=MockitoJUnitRunner.class)
public class MultipleIndexPopulatorTest {
    private final LabelSchemaDescriptor index1 = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
    @Mock
    private IndexStoreView indexStoreView;
    @Mock
    private StoreScan storeScan;
    @Mock(answer=Answers.RETURNS_MOCKS)
    private LogProvider logProvider;
    @Mock
    private SchemaState schemaState;
    @InjectMocks
    private MultipleIndexPopulator multipleIndexPopulator;

    @Test
    public void canceledPopulationNotAbleToCreateNewIndex() throws IOException, FlipFailedKernelException {
        IndexPopulator populator = this.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation indexPopulation = this.addPopulator(populator, 1);
        indexPopulation.cancel();
        this.multipleIndexPopulator.create();
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).create();
    }

    @Test
    public void canceledPopulationNotAbleToFlip() throws IOException, FlipFailedKernelException {
        IndexPopulator populator = this.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation indexPopulation = this.addPopulator(populator, 1);
        indexPopulation.cancel();
        indexPopulation.flip();
        ((IndexPopulator)Mockito.verify((Object)indexPopulation.populator, (VerificationMode)Mockito.never())).sampleResult();
    }

    @Test
    public void flippedPopulationAreNotCanceable() throws IOException, FlipFailedKernelException {
        IndexPopulator populator = this.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation indexPopulation = this.addPopulator(populator, 1);
        indexPopulation.flip();
        indexPopulation.cancel();
        ((IndexPopulator)Mockito.verify((Object)indexPopulation.populator, (VerificationMode)Mockito.never())).close(false);
    }

    @Test
    public void testMultiplePopulatorsCreation() throws Exception {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.create();
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).create();
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).create();
    }

    @Test
    public void testMultiplePopulatorCreationFailure() throws IOException, FlipFailedKernelException {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        IndexPopulator indexPopulator3 = this.createIndexPopulator();
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{this.getPopulatorException()}).when((Object)indexPopulator1)).create();
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{this.getPopulatorException()}).when((Object)indexPopulator3)).create();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.addPopulator(indexPopulator3, 3);
        this.multipleIndexPopulator.create();
        this.checkPopulatorFailure(indexPopulator1);
        this.checkPopulatorFailure(indexPopulator3);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).create();
    }

    @Test
    public void testHasPopulators() throws FlipFailedKernelException {
        Assert.assertFalse((boolean)this.multipleIndexPopulator.hasPopulators());
        this.addPopulator(this.createIndexPopulator(), 42);
        Assert.assertTrue((boolean)this.multipleIndexPopulator.hasPopulators());
    }

    @Test
    public void cancelingSinglePopulatorDoNotCancelAnyOther() throws IOException, FlipFailedKernelException {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation populationToCancel = this.addPopulator(indexPopulator1, 1);
        MultipleIndexPopulator.IndexPopulation populationToKeepActive = this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.create();
        this.multipleIndexPopulator.cancelIndexPopulation(populationToCancel);
        this.multipleIndexPopulator.indexAllNodes();
        Assert.assertTrue((boolean)this.multipleIndexPopulator.hasPopulators());
        this.multipleIndexPopulator.flipAfterPopulation();
        ((FlippableIndexProxy)Mockito.verify((Object)populationToKeepActive.flipper)).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
    }

    @Test
    public void canceledPopulatorDoNotFlipWhenPopulationCompleted() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation populationToCancel = this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.create();
        this.multipleIndexPopulator.cancelIndexPopulation(populationToCancel);
        this.multipleIndexPopulator.indexAllNodes();
        Assert.assertTrue((boolean)this.multipleIndexPopulator.hasPopulators());
        this.multipleIndexPopulator.flipAfterPopulation();
        ((FlippableIndexProxy)Mockito.verify((Object)populationToCancel.flipper, (VerificationMode)Mockito.never())).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
    }

    @Test
    public void testIndexAllNodes() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.create();
        this.multipleIndexPopulator.indexAllNodes();
        ((IndexStoreView)Mockito.verify((Object)this.indexStoreView)).visitNodes((int[])ArgumentMatchers.any(int[].class), (IntPredicate)ArgumentMatchers.any(IntPredicate.class), (Visitor)ArgumentMatchers.any(Visitor.class), (Visitor)ArgumentMatchers.isNull(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testFailPopulator() throws IOException, FlipFailedKernelException {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.fail((Throwable)this.getPopulatorException());
        this.checkPopulatorFailure(indexPopulator1);
        this.checkPopulatorFailure(indexPopulator2);
    }

    @Test
    public void testFailByPopulation() throws IOException, FlipFailedKernelException {
        IndexPopulator populator1 = this.createIndexPopulator();
        IndexPopulator populator2 = this.createIndexPopulator();
        this.addPopulator(populator1, 1);
        MultipleIndexPopulator.IndexPopulation population2 = this.addPopulator(populator2, 2);
        this.multipleIndexPopulator.fail(population2, (Throwable)this.getPopulatorException());
        ((IndexPopulator)Mockito.verify((Object)populator1, (VerificationMode)Mockito.never())).markAsFailed(ArgumentMatchers.anyString());
        this.checkPopulatorFailure(populator2);
    }

    @Test
    public void testFailByPopulationRemovesPopulator() throws IOException, FlipFailedKernelException {
        IndexPopulator populator1 = this.createIndexPopulator();
        IndexPopulator populator2 = this.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation population1 = this.addPopulator(populator1, 1);
        MultipleIndexPopulator.IndexPopulation population2 = this.addPopulator(populator2, 2);
        this.multipleIndexPopulator.fail(population1, (Throwable)this.getPopulatorException());
        this.multipleIndexPopulator.fail(population2, (Throwable)this.getPopulatorException());
        this.checkPopulatorFailure(populator1);
        this.checkPopulatorFailure(populator2);
        Assert.assertFalse((boolean)this.multipleIndexPopulator.hasPopulators());
    }

    @Test
    public void testFailByNonExistingPopulation() throws IOException, FlipFailedKernelException {
        MultipleIndexPopulator.IndexPopulation nonExistingPopulation = (MultipleIndexPopulator.IndexPopulation)Mockito.mock(MultipleIndexPopulator.IndexPopulation.class);
        IndexPopulator populator = this.createIndexPopulator();
        this.addPopulator(populator, 1);
        this.multipleIndexPopulator.fail(nonExistingPopulation, (Throwable)this.getPopulatorException());
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).markAsFailed(ArgumentMatchers.anyString());
    }

    @Test
    public void closeMultipleIndexPopulator() throws IOException, FlipFailedKernelException {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{this.getPopulatorException()}).when((Object)indexPopulator2)).close(true);
        this.multipleIndexPopulator.close(true);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).close(true);
        this.checkPopulatorFailure(indexPopulator2);
    }

    @Test
    public void testFlipAfterPopulation() throws Exception {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        FlippableIndexProxy flipper1 = this.addPopulator((IndexPopulator)indexPopulator1, (int)1).flipper;
        FlippableIndexProxy flipper2 = this.addPopulator((IndexPopulator)indexPopulator2, (int)2).flipper;
        this.multipleIndexPopulator.flipAfterPopulation();
        ((FlippableIndexProxy)Mockito.verify((Object)flipper1)).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
        ((FlippableIndexProxy)Mockito.verify((Object)flipper2)).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
    }

    @Test
    public void populationsRemovedDuringFlip() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        Assert.assertTrue((boolean)this.multipleIndexPopulator.hasPopulators());
        this.multipleIndexPopulator.flipAfterPopulation();
        Assert.assertFalse((boolean)this.multipleIndexPopulator.hasPopulators());
    }

    @Test
    public void testCancelPopulation() throws IOException, FlipFailedKernelException {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.cancel();
        ((IndexStoreView)Mockito.verify((Object)this.indexStoreView, (VerificationMode)Mockito.times((int)2))).replaceIndexCounts(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)0L));
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).close(false);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).close(false);
    }

    @Test
    public void testIndexFlip() throws IOException {
        IndexProxyFactory indexProxyFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FailedIndexProxyFactory failedIndexProxyFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(indexProxyFactory);
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1, flipper, failedIndexProxyFactory);
        this.addPopulator(indexPopulator2, 2, flipper, failedIndexProxyFactory);
        Mockito.when((Object)indexPopulator1.sampleResult()).thenThrow(new Throwable[]{this.getSampleError()});
        this.multipleIndexPopulator.indexAllNodes();
        this.multipleIndexPopulator.flipAfterPopulation();
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).close(false);
        ((FailedIndexProxyFactory)Mockito.verify((Object)failedIndexProxyFactory, (VerificationMode)Mockito.times((int)1))).create((Throwable)ArgumentMatchers.any(RuntimeException.class));
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).close(true);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).sampleResult();
        ((IndexStoreView)Mockito.verify((Object)this.indexStoreView)).replaceIndexCounts(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((SchemaState)Mockito.verify((Object)this.schemaState)).clear();
    }

    @Test
    public void testMultiplePopulatorUpdater() throws IOException, IndexEntryConflictException, FlipFailedKernelException {
        IndexUpdater indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator indexPopulator1 = this.createIndexPopulator(indexUpdater1);
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{new UncheckedIOException(this.getPopulatorException())}).when((Object)indexPopulator2)).newPopulatingUpdater((PropertyAccessor)ArgumentMatchers.any(PropertyAccessor.class));
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater((PropertyAccessor)Mockito.mock(PropertyAccessor.class));
        IndexEntryUpdate<?> propertyUpdate = this.createIndexEntryUpdate(this.index1);
        multipleIndexUpdater.process(propertyUpdate);
        this.checkPopulatorFailure(indexPopulator2);
        ((IndexUpdater)Mockito.verify((Object)indexUpdater1)).process(propertyUpdate);
    }

    @Test
    public void testNonApplicableUpdaterDoNotUpdatePopulator() throws IOException, IndexEntryConflictException, FlipFailedKernelException {
        IndexUpdater indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator indexPopulator1 = this.createIndexPopulator(indexUpdater1);
        this.addPopulator(indexPopulator1, 2);
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater((PropertyAccessor)Mockito.mock(PropertyAccessor.class));
        IndexEntryUpdate<?> propertyUpdate = this.createIndexEntryUpdate(this.index1);
        multipleIndexUpdater.process(propertyUpdate);
        Mockito.verifyZeroInteractions((Object[])new Object[]{indexUpdater1});
    }

    @Test
    public void testPropertyUpdateFailure() throws IOException, IndexEntryConflictException, FlipFailedKernelException {
        IndexEntryUpdate<?> propertyUpdate = this.createIndexEntryUpdate(this.index1);
        IndexUpdater indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator indexPopulator1 = this.createIndexPopulator(indexUpdater1);
        this.addPopulator(indexPopulator1, 1);
        ((IndexUpdater)Mockito.doThrow((Throwable[])new Throwable[]{this.getPopulatorException()}).when((Object)indexUpdater1)).process(propertyUpdate);
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater((PropertyAccessor)Mockito.mock(PropertyAccessor.class));
        multipleIndexUpdater.process(propertyUpdate);
        ((IndexUpdater)Mockito.verify((Object)indexUpdater1)).close();
        this.checkPopulatorFailure(indexPopulator1);
    }

    @Test
    public void testMultiplePropertyUpdateFailures() throws IOException, IndexEntryConflictException, FlipFailedKernelException {
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        IndexEntryUpdate<SchemaDescriptor> update1 = IndexQueryHelper.add(1L, (SchemaDescriptor)this.index1, "foo");
        IndexEntryUpdate<SchemaDescriptor> update2 = IndexQueryHelper.add(2L, (SchemaDescriptor)this.index1, "bar");
        IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator populator = this.createIndexPopulator(updater);
        this.addPopulator(populator, 1);
        ((IndexUpdater)Mockito.doThrow((Throwable[])new Throwable[]{this.getPopulatorException()}).when((Object)updater)).process((IndexEntryUpdate)ArgumentMatchers.any(IndexEntryUpdate.class));
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater(propertyAccessor);
        multipleIndexUpdater.process(update1);
        multipleIndexUpdater.process(update2);
        ((IndexUpdater)Mockito.verify((Object)updater)).process(update1);
        ((IndexUpdater)Mockito.verify((Object)updater, (VerificationMode)Mockito.never())).process(update2);
        ((IndexUpdater)Mockito.verify((Object)updater)).close();
        this.checkPopulatorFailure(populator);
    }

    private IndexEntryUpdate<?> createIndexEntryUpdate(LabelSchemaDescriptor schemaDescriptor) {
        return IndexQueryHelper.add(1L, (SchemaDescriptor)schemaDescriptor, "theValue");
    }

    private RuntimeException getSampleError() {
        return new RuntimeException("sample error");
    }

    private IndexPopulator createIndexPopulator(IndexUpdater indexUpdater) throws IOException {
        IndexPopulator indexPopulator = this.createIndexPopulator();
        Mockito.when((Object)indexPopulator.newPopulatingUpdater((PropertyAccessor)ArgumentMatchers.any(PropertyAccessor.class))).thenReturn((Object)indexUpdater);
        return indexPopulator;
    }

    private IndexPopulator createIndexPopulator() {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        Mockito.when((Object)populator.sampleResult()).thenReturn((Object)new IndexSample());
        return populator;
    }

    private IOException getPopulatorException() {
        return new IOException("something went wrong");
    }

    private void checkPopulatorFailure(IndexPopulator populator) throws IOException {
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(ArgumentMatchers.contains((String)"something went wrong"));
        ((IndexPopulator)Mockito.verify((Object)populator)).close(false);
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(IndexPopulator indexPopulator, int id, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        return this.addPopulator(this.multipleIndexPopulator, indexPopulator, id, flippableIndexProxy, failedIndexProxyFactory);
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(MultipleIndexPopulator multipleIndexPopulator, IndexPopulator indexPopulator, int id, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        return this.addPopulator(multipleIndexPopulator, id, SchemaIndexDescriptorFactory.forLabel((int)id, (int[])new int[]{id}), indexPopulator, flippableIndexProxy, failedIndexProxyFactory);
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(MultipleIndexPopulator multipleIndexPopulator, long indexId, SchemaIndexDescriptor descriptor, IndexPopulator indexPopulator, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        return multipleIndexPopulator.addPopulator(indexPopulator, indexId, new IndexMeta(indexId, descriptor, (IndexProvider.Descriptor)Mockito.mock(IndexProvider.Descriptor.class), IndexCapability.NO_CAPABILITY), flippableIndexProxy, failedIndexProxyFactory, "userIndexDescription");
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(IndexPopulator indexPopulator, int id) throws FlipFailedKernelException {
        FlippableIndexProxy indexProxy = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        Mockito.when((Object)indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        ((FlippableIndexProxy)Mockito.doAnswer(invocation -> {
            Callable argument = (Callable)invocation.getArgument(0);
            return argument.call();
        }).when((Object)indexProxy)).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
        return this.addPopulator(indexPopulator, id, indexProxy, (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class));
    }
}

