/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.impl.api.IndexTextValueLengthValidator;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexTextValueLengthValidatorTest {
    private static final int MAX_BYTE_LENGTH = 20000;
    private IndexTextValueLengthValidator validator = new IndexTextValueLengthValidator(20000);
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @Test
    public void tooLongByteArrayIsNotAllowed() {
        int length = 40000;
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Property value size is too large for index. Please see index documentation for limitations."));
        this.validator.validate(RandomUtils.nextBytes((int)length));
    }

    @Test
    public void tooLongStringIsNotAllowed() {
        int length = 40000;
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Property value size is too large for index. Please see index documentation for limitations."));
        this.validator.validate(this.string(length));
    }

    @Test
    public void shortByteArrayIsValid() {
        this.validator.validate(RandomUtils.nextBytes((int)3));
        this.validator.validate(RandomUtils.nextBytes((int)30));
        this.validator.validate(RandomUtils.nextBytes((int)300));
        this.validator.validate(RandomUtils.nextBytes((int)4303));
        this.validator.validate(RandomUtils.nextBytes((int)13234));
        this.validator.validate(RandomUtils.nextBytes((int)20000));
    }

    @Test
    public void shortStringIsValid() {
        this.validator.validate(this.string(3));
        this.validator.validate(this.string(30));
        this.validator.validate(this.string(300));
        this.validator.validate(this.string(4303));
        this.validator.validate(this.string(13234));
        this.validator.validate(this.string(20000));
    }

    @Test
    public void nullIsNotAllowed() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Null value");
        this.validator.validate((byte[])null);
    }

    @Test
    public void nullValueIsNotAllowed() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Null value");
        this.validator.validate((Value)null);
    }

    @Test
    public void noValueIsNotAllowed() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Null value");
        this.validator.validate(Values.NO_VALUE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailOnTooLongNonLatinString() {
        byte[] facesBytes = this.stringOfEmojis(1);
        this.validator.validate((Value)Values.stringValue((String)new String(facesBytes, StandardCharsets.UTF_8)));
    }

    @Test
    public void shouldSucceedOnReasonablyLongNonLatinString() {
        byte[] facesBytes = this.stringOfEmojis(0);
        this.validator.validate((Value)Values.stringValue((String)new String(facesBytes, StandardCharsets.UTF_8)));
    }

    private byte[] stringOfEmojis(int beyondMax) {
        byte[] poutingFaceSymbol = "\ud83d\ude21".getBytes();
        int count = 20000 / poutingFaceSymbol.length + beyondMax;
        byte[] facesBytes = new byte[poutingFaceSymbol.length * count];
        for (int i = 0; i < count; ++i) {
            System.arraycopy(poutingFaceSymbol, 0, facesBytes, i * poutingFaceSymbol.length, poutingFaceSymbol.length);
        }
        return facesBytes;
    }

    private Value string(int length) {
        return Values.stringValue((String)RandomStringUtils.randomAlphabetic((int)length));
    }
}

