/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;

public abstract class CoarseBoundedProgressExecutionMonitor
extends ExecutionMonitor.Adapter {
    private final long totalNumberOfBatches;
    private long prevDoneBatches;
    private long totalReportedBatches;

    public CoarseBoundedProgressExecutionMonitor(long highNodeId, long highRelationshipId, Configuration configuration) {
        super(1L, TimeUnit.SECONDS);
        this.totalNumberOfBatches = highNodeId / (long)configuration.batchSize() * 3L + highRelationshipId / (long)configuration.batchSize() * 4L;
    }

    protected long total() {
        return this.totalNumberOfBatches;
    }

    @Override
    public void check(StageExecution execution) {
        this.update(execution);
    }

    @Override
    public void start(StageExecution execution) {
        this.prevDoneBatches = 0L;
    }

    private void update(StageExecution execution) {
        long diff = 0L;
        long doneBatches = this.doneBatches(execution);
        this.prevDoneBatches = doneBatches;
        if ((diff += doneBatches - this.prevDoneBatches) > 0L) {
            this.totalReportedBatches += diff;
            this.progress(diff);
        }
    }

    protected abstract void progress(long var1);

    private long doneBatches(StageExecution execution) {
        Step step = (Step)Iterables.last(execution.steps());
        return step.stats().stat(Keys.done_batches).asLong();
    }

    @Override
    public void done(boolean successful, long totalTimeMillis, String additionalInformation) {
        this.progress(this.totalNumberOfBatches - this.totalReportedBatches);
    }
}

