/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;

class DiffApplyingLongIterator
extends PrimitiveLongCollections.PrimitiveLongBaseIterator
implements PrimitiveLongResourceIterator {
    private final PrimitiveLongIterator source;
    private final Iterator<?> addedElementsIterator;
    private final Set<?> addedElements;
    private final Set<?> removedElements;
    @Nullable
    private final Resource resource;
    protected Phase phase;

    DiffApplyingLongIterator(PrimitiveLongIterator source, Set<?> addedElements, Set<?> removedElements, @Nullable Resource resource) {
        this.source = source;
        this.addedElements = addedElements;
        this.addedElementsIterator = addedElements.iterator();
        this.removedElements = removedElements;
        this.resource = resource;
        this.phase = Phase.FILTERED_SOURCE;
    }

    static PrimitiveLongIterator augment(PrimitiveLongIterator source, Set<?> addedElements, Set<?> removedElements) {
        return new DiffApplyingLongIterator(source, addedElements, removedElements, null);
    }

    static PrimitiveLongResourceIterator augment(PrimitiveLongResourceIterator source, Set<?> addedElements, Set<?> removedElements) {
        return new DiffApplyingLongIterator((PrimitiveLongIterator)source, addedElements, removedElements, (Resource)source);
    }

    protected boolean fetchNext() {
        return this.phase.fetchNext(this);
    }

    private boolean computeNextFromSourceAndFilter() {
        while (this.source.hasNext()) {
            long value = this.source.next();
            if (this.removedElements.contains(value) || this.addedElements.contains(value)) continue;
            return this.next(value);
        }
        this.transitionToAddedElements();
        return this.phase.fetchNext(this);
    }

    private void transitionToAddedElements() {
        this.phase = this.addedElementsIterator.hasNext() ? Phase.ADDED_ELEMENTS : Phase.NO_ADDED_ELEMENTS;
    }

    private boolean computeNextFromAddedElements() {
        return this.addedElementsIterator.hasNext() && this.next((Long)this.addedElementsIterator.next());
    }

    public void close() {
        if (this.resource != null) {
            this.resource.close();
        }
    }

    protected static enum Phase {
        FILTERED_SOURCE{

            @Override
            boolean fetchNext(DiffApplyingLongIterator self) {
                return self.computeNextFromSourceAndFilter();
            }
        }
        ,
        ADDED_ELEMENTS{

            @Override
            boolean fetchNext(DiffApplyingLongIterator self) {
                return self.computeNextFromAddedElements();
            }
        }
        ,
        NO_ADDED_ELEMENTS{

            @Override
            boolean fetchNext(DiffApplyingLongIterator self) {
                return false;
            }
        };


        abstract boolean fetchNext(DiffApplyingLongIterator var1);
    }
}

