/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Iterator;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyRecordChange;
import org.neo4j.values.storable.Value;

public class PropertyPhysicalToLogicalConverter {
    private final PropertyStore propertyStore;

    public PropertyPhysicalToLogicalConverter(PropertyStore propertyStore) {
        this.propertyStore = propertyStore;
    }

    public void convertPropertyRecord(long nodeId, Iterable<PropertyRecordChange> changes, NodeUpdates.Builder properties) {
        PrimitiveIntObjectMap beforeMap = Primitive.intObjectMap();
        PrimitiveIntObjectMap afterMap = Primitive.intObjectMap();
        this.mapBlocks(nodeId, changes, (PrimitiveIntObjectMap<PropertyBlock>)beforeMap, (PrimitiveIntObjectMap<PropertyBlock>)afterMap);
        PrimitiveIntIterator uniqueIntIterator = this.uniqueIntIterator((PrimitiveIntObjectMap<PropertyBlock>)beforeMap, (PrimitiveIntObjectMap<PropertyBlock>)afterMap);
        while (uniqueIntIterator.hasNext()) {
            int key = uniqueIntIterator.next();
            PropertyBlock beforeBlock = (PropertyBlock)beforeMap.get(key);
            PropertyBlock afterBlock = (PropertyBlock)afterMap.get(key);
            if (beforeBlock != null && afterBlock != null) {
                if (beforeBlock.hasSameContentsAs(afterBlock)) continue;
                Value beforeVal = this.valueOf(beforeBlock);
                Value afterVal = this.valueOf(afterBlock);
                properties.changed(key, beforeVal, afterVal);
                continue;
            }
            if (afterBlock != null) {
                properties.added(key, this.valueOf(afterBlock));
                continue;
            }
            if (beforeBlock != null) {
                properties.removed(key, this.valueOf(beforeBlock));
                continue;
            }
            throw new IllegalStateException("Weird, an update with no property value for before or after");
        }
    }

    private PrimitiveIntIterator uniqueIntIterator(PrimitiveIntObjectMap<PropertyBlock> beforeMap, PrimitiveIntObjectMap<PropertyBlock> afterMap) {
        Iterator intIterator = Iterators.asIterator((int)2, (Object[])new PrimitiveIntIterator[]{beforeMap.iterator(), afterMap.iterator()});
        return PrimitiveIntCollections.deduplicate((PrimitiveIntIterator)PrimitiveIntCollections.concat((Iterator)intIterator));
    }

    private void mapBlocks(long nodeId, Iterable<PropertyRecordChange> changes, PrimitiveIntObjectMap<PropertyBlock> beforeMap, PrimitiveIntObjectMap<PropertyBlock> afterMap) {
        for (PropertyRecordChange change : changes) {
            this.equalCheck(change.getBefore().getNodeId(), nodeId);
            this.equalCheck(change.getAfter().getNodeId(), nodeId);
            this.mapBlocks(change.getBefore(), beforeMap);
            this.mapBlocks(change.getAfter(), afterMap);
        }
    }

    private void equalCheck(long nodeId, long expectedNodeId) {
        assert (nodeId == expectedNodeId) : "Node id differs expected " + expectedNodeId + ", but was " + nodeId;
    }

    private void mapBlocks(PropertyRecord record, PrimitiveIntObjectMap<PropertyBlock> blocks) {
        for (PropertyBlock block : record) {
            blocks.put(block.getKeyIndexId(), (Object)block);
        }
    }

    private Value valueOf(PropertyBlock block) {
        if (block == null) {
            return null;
        }
        return block.getType().value(block, this.propertyStore);
    }
}

