/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions;

import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.storageengine.api.EntityType;

public class PropertyNotFoundException
extends KernelException {
    private final String entity;
    private final int propertyKeyId;

    public PropertyNotFoundException(int propertyKeyId, EntityType entityType, long entityId) {
        this(entityType == EntityType.GRAPH ? "GraphProperties" : entityType.name() + "[" + entityId + "]", propertyKeyId);
    }

    private PropertyNotFoundException(String entity, int propertyKeyId) {
        super((Status)Status.Statement.PropertyNotFound, "%s has no property with propertyKeyId=%s.", new Object[]{entity, propertyKeyId});
        this.entity = entity;
        this.propertyKeyId = propertyKeyId;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("%s has no property with propertyKey=\"%s\".", this.entity, tokenNameLookup.propertyKeyGetName(this.propertyKeyId));
    }
}

