/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.Closeable;
import java.io.IOException;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;

public interface InputIterator
extends Closeable {
    public InputChunk newChunk();

    public boolean next(InputChunk var1) throws IOException;

    public static class Empty
    extends Adapter {
        @Override
        public InputChunk newChunk() {
            return InputChunk.EMPTY;
        }

        @Override
        public boolean next(InputChunk chunk) {
            return false;
        }
    }

    public static class Delegate
    implements InputIterator {
        protected final InputIterator actual;

        public Delegate(InputIterator actual) {
            this.actual = actual;
        }

        @Override
        public void close() throws IOException {
            this.actual.close();
        }

        @Override
        public InputChunk newChunk() {
            return this.actual.newChunk();
        }

        @Override
        public boolean next(InputChunk chunk) throws IOException {
            return this.actual.next(chunk);
        }
    }

    public static abstract class Adapter
    implements InputIterator {
        @Override
        public void close() {
        }
    }
}

