/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexingService;

public class IndexActivator
implements AutoCloseable {
    private final IndexingService indexingService;
    private Set<Long> indexesToActivate;

    public IndexActivator(IndexingService indexingService) {
        this.indexingService = indexingService;
    }

    @Override
    public void close() {
        if (this.indexesToActivate != null) {
            for (long indexId : this.indexesToActivate) {
                try {
                    this.indexingService.activateIndex(indexId);
                }
                catch (IndexActivationFailedKernelException | IndexNotFoundKernelException | IndexPopulationFailedKernelException e) {
                    throw new IllegalStateException("Unable to enable constraint, backing index is not online.", (Throwable)e);
                }
            }
        }
    }

    void activateIndex(long indexId) {
        if (this.indexesToActivate == null) {
            this.indexesToActivate = new HashSet<Long>();
        }
        this.indexesToActivate.add(indexId);
    }

    void indexDropped(long indexId) {
        if (this.indexesToActivate != null) {
            this.indexesToActivate.remove(indexId);
        }
    }
}

