/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Collections;
import java.util.Set;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;

public class MultipleUnderlyingStorageExceptions
extends UnderlyingStorageException {
    public final Set<Pair<SchemaDescriptor, UnderlyingStorageException>> exceptions;

    public MultipleUnderlyingStorageExceptions(Set<Pair<SchemaDescriptor, UnderlyingStorageException>> exceptions) {
        super(MultipleUnderlyingStorageExceptions.buildMessage(exceptions));
        this.exceptions = Collections.unmodifiableSet(exceptions);
        for (Pair<SchemaDescriptor, UnderlyingStorageException> exception : exceptions) {
            this.addSuppressed((Throwable)exception.other());
        }
    }

    private static String buildMessage(Set<Pair<SchemaDescriptor, UnderlyingStorageException>> exceptions) {
        StringBuilder builder = new StringBuilder();
        builder.append("Errors when closing (flushing) index updaters:");
        for (Pair<SchemaDescriptor, UnderlyingStorageException> pair : exceptions) {
            builder.append(String.format(" (%s) %s", ((SchemaDescriptor)pair.first()).toString(), ((UnderlyingStorageException)pair.other()).getMessage()));
        }
        return builder.toString();
    }
}

