/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import org.neo4j.function.ThrowingConsumer;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.helpers.Exceptions;

class InstanceSelector<T> {
    final T[] instances;
    boolean closed;

    InstanceSelector(T[] instances) {
        this.instances = instances;
    }

    T select(int slot) {
        if (this.instances[slot] == null) {
            throw new IllegalStateException("Instance is not instantiated");
        }
        return this.instances[slot];
    }

    <R, E extends Exception> R[] instancesAs(R[] target, ThrowingFunction<T, R, E> converter) throws E {
        for (int slot = 0; slot < this.instances.length; ++slot) {
            target[slot] = converter.apply(this.select(slot));
        }
        return target;
    }

    <E extends Exception> void forAll(ThrowingConsumer<T, E> consumer) throws E {
        Object exception = null;
        for (int slot = 0; slot < this.instances.length; ++slot) {
            exception = InstanceSelector.consume(exception, consumer, this.select(slot));
        }
        if (exception != null) {
            throw exception;
        }
    }

    <E extends Exception> void close(ThrowingConsumer<T, E> consumer) throws E {
        if (!this.closed) {
            try {
                this.forInstantiated(consumer);
            }
            finally {
                this.closed = true;
            }
        }
    }

    private <E extends Exception> void forInstantiated(ThrowingConsumer<T, E> consumer) throws E {
        Object exception = null;
        for (T instance : this.instances) {
            if (instance == null) continue;
            exception = InstanceSelector.consume(exception, consumer, instance);
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static <E extends Exception, T> E consume(E exception, ThrowingConsumer<T, E> consumer, T instance) {
        try {
            consumer.accept(instance);
        }
        catch (Exception e) {
            exception = (Exception)Exceptions.chain(exception, (Throwable)e);
        }
        return exception;
    }
}

