/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexReader;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;

class FusionIndexAccessor
extends FusionIndexBase<IndexAccessor>
implements IndexAccessor {
    private final long indexId;
    private final SchemaIndexDescriptor descriptor;
    private final FusionIndexProvider.DropAction dropAction;

    FusionIndexAccessor(SlotSelector slotSelector, InstanceSelector<IndexAccessor> instanceSelector, long indexId, SchemaIndexDescriptor descriptor, FusionIndexProvider.DropAction dropAction) {
        super(slotSelector, instanceSelector);
        this.indexId = indexId;
        this.descriptor = descriptor;
        this.dropAction = dropAction;
    }

    @Override
    public void drop() throws IOException {
        this.instanceSelector.forAll(IndexAccessor::drop);
        this.dropAction.drop(this.indexId);
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        LazyInstanceSelector<IndexUpdater> updaterSelector = new LazyInstanceSelector<IndexUpdater>(new IndexUpdater[5], slot -> ((IndexAccessor)this.instanceSelector.select(slot)).newUpdater(mode));
        return new FusionIndexUpdater(this.slotSelector, updaterSelector);
    }

    @Override
    public void force(IOLimiter ioLimiter) throws IOException {
        this.instanceSelector.forAll(accessor -> accessor.force(ioLimiter));
    }

    @Override
    public void refresh() throws IOException {
        this.instanceSelector.forAll(IndexAccessor::refresh);
    }

    @Override
    public void close() throws IOException {
        this.instanceSelector.close(IndexAccessor::close);
    }

    @Override
    public IndexReader newReader() {
        LazyInstanceSelector<IndexReader> readerSelector = new LazyInstanceSelector<IndexReader>(new IndexReader[5], slot -> ((IndexAccessor)this.instanceSelector.select(slot)).newReader());
        return new FusionIndexReader(this.slotSelector, readerSelector, this.descriptor);
    }

    @Override
    public BoundedIterable<Long> newAllEntriesReader() {
        final BoundedIterable[] entries = this.instanceSelector.instancesAs(new BoundedIterable[5], IndexAccessor::newAllEntriesReader);
        return new BoundedIterable<Long>(){

            @Override
            public long maxCount() {
                long[] maxCounts = new long[entries.length];
                long sum = 0L;
                for (int i = 0; i < entries.length; ++i) {
                    maxCounts[i] = entries[i].maxCount();
                    sum += maxCounts[i];
                }
                return this.existsUnknownMaxCount(maxCounts) ? -1L : sum;
            }

            private boolean existsUnknownMaxCount(long ... maxCounts) {
                for (long maxCount : maxCounts) {
                    if (maxCount != -1L) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void close() throws Exception {
                FusionIndexBase.forAll(AutoCloseable::close, entries);
            }

            @Override
            public Iterator<Long> iterator() {
                return Iterables.concat((Iterable[])entries).iterator();
            }
        };
    }

    @Override
    public ResourceIterator<File> snapshotFiles() throws IOException {
        return Iterators.concatResourceIterators((Iterator)Iterators.iterator((Object[])this.instanceSelector.instancesAs(new ResourceIterator[5], accessor -> accessor.snapshotFiles())));
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
        for (int slot = 0; slot < 5; ++slot) {
            ((IndexAccessor)this.instanceSelector.select(slot)).verifyDeferredConstraints(propertyAccessor);
        }
    }

    @Override
    public boolean isDirty() {
        boolean isDirty = false;
        for (int slot = 0; slot < 5; ++slot) {
            isDirty |= ((IndexAccessor)this.instanceSelector.select(slot)).isDirty();
        }
        return isDirty;
    }

    @Override
    public void validateBeforeCommit(Value[] tuple) {
        ((IndexAccessor)this.instanceSelector.select(this.slotSelector.selectSlot(tuple, GROUP_OF))).validateBeforeCommit(tuple);
    }
}

