/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.NumberSchemaKey;
import org.neo4j.kernel.impl.index.schema.SchemaLayout;

abstract class NumberLayout
extends SchemaLayout<NumberSchemaKey> {
    NumberLayout(long identifier, int majorVersion, int minorVersion) {
        super(identifier, majorVersion, minorVersion);
    }

    public NumberSchemaKey newKey() {
        return new NumberSchemaKey();
    }

    public NumberSchemaKey copyKey(NumberSchemaKey key, NumberSchemaKey into) {
        into.type = key.type;
        into.rawValueBits = key.rawValueBits;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    public int keySize(NumberSchemaKey key) {
        return 17;
    }

    public void writeKey(PageCursor cursor, NumberSchemaKey key) {
        cursor.putByte(key.type);
        cursor.putLong(key.rawValueBits);
        cursor.putLong(key.getEntityId());
    }

    public void readKey(PageCursor cursor, NumberSchemaKey into, int keySize) {
        into.type = cursor.getByte();
        into.rawValueBits = cursor.getLong();
        into.setEntityId(cursor.getLong());
    }

    @Override
    int compareValue(NumberSchemaKey o1, NumberSchemaKey o2) {
        return o1.compareValueTo(o2);
    }
}

